/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FloatingTextField;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextCreationTool
extends CreationTool
implements ActionListener {
    private FloatingTextField textField;
    private TextHolderFigure typingTarget;

    public TextCreationTool(TextHolderFigure prototype) {
        super(prototype);
    }

    public TextCreationTool(TextHolderFigure prototype, Map<AttributeKey, Object> attributes) {
        super(prototype, attributes);
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TextHolderFigure textHolder = null;
        DrawingView v = this.getView();
        Point2D.Double p = v.viewToDrawing(e.getPoint());
        Figure pressedFigure = null;
        for (Figure f : v.getSelectedFigures()) {
            if (!f.contains(p)) continue;
            pressedFigure = f;
            break;
        }
        if (pressedFigure == null) {
            pressedFigure = this.getDrawing().findFigureInside(p);
        }
        if (pressedFigure instanceof TextHolderFigure) {
            textHolder = ((TextHolderFigure)pressedFigure).getLabelFor();
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder);
            this.updateCursor(this.getView(), e.getPoint());
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            if (this.isToolDoneAfterCreation()) {
                this.fireToolDone();
            }
        } else {
            super.mousePressed(e);
            textHolder = (TextHolderFigure)this.getCreatedFigure();
            this.getView().clearSelection();
            this.getView().addToSelection(textHolder);
            this.beginEdit(textHolder);
            this.updateCursor(this.getView(), e.getPoint());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    protected void beginEdit(TextHolderFigure textHolder) {
        if (this.textField == null) {
            this.textField = new FloatingTextField();
            this.textField.addActionListener(this);
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textField.createOverlay(this.getView(), textHolder);
        this.textField.requestFocus();
        this.typingTarget = textHolder;
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            final TextHolderFigure editedFigure = this.typingTarget;
            final String oldText = this.typingTarget.getText();
            final String newText = this.textField.getText();
            if (newText.length() > 0) {
                this.typingTarget.setText(newText);
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
                this.typingTarget.changed();
            }
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return labels.getString("attribute.text.text");
                }

                public void undo() {
                    super.undo();
                    editedFigure.willChange();
                    editedFigure.setText(oldText);
                    editedFigure.changed();
                }

                public void redo() {
                    super.redo();
                    editedFigure.willChange();
                    editedFigure.setText(newText);
                    editedFigure.changed();
                }
            };
            this.getDrawing().fireUndoableEditHappened(edit);
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textField.endOverlay();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 27 || this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    @Override
    protected void creationFinished(Figure createdFigure) {
        this.beginEdit((TextHolderFigure)createdFigure);
        this.updateCursor(this.getView(), new Point(0, 0));
    }

    public boolean isEditing() {
        return this.typingTarget != null;
    }

    @Override
    public void updateCursor(DrawingView view, Point p) {
        if (view.isEnabled()) {
            view.setCursor(Cursor.getPredefinedCursor(this.isEditing() ? 0 : 1));
        } else {
            view.setCursor(Cursor.getPredefinedCursor(3));
        }
    }
}

