/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FloatingTextArea;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAreaCreationTool
extends CreationTool
implements ActionListener {
    private FloatingTextArea textArea;
    private TextHolderFigure typingTarget;
    private Color rubberbandColor = null;

    public TextAreaCreationTool(TextHolderFigure prototype) {
        super(prototype);
    }

    public TextAreaCreationTool(TextHolderFigure prototype, Map<AttributeKey, Object> attributes) {
        super(prototype, attributes);
    }

    public void setRubberbandColor(Color c) {
        this.rubberbandColor = c;
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TextHolderFigure textHolder = null;
        DrawingView v = this.getView();
        Point2D.Double p = v.viewToDrawing(e.getPoint());
        Figure pressedFigure = null;
        for (Figure f : v.getSelectedFigures()) {
            if (!f.contains(p)) continue;
            pressedFigure = f;
            break;
        }
        if (pressedFigure == null) {
            pressedFigure = this.getDrawing().findFigureInside(p);
        }
        if (pressedFigure instanceof TextHolderFigure) {
            textHolder = (TextHolderFigure)pressedFigure;
            textHolder = null;
        }
        if (textHolder != null) {
            this.createdFigure = null;
            this.beginEdit(textHolder);
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            if (this.isToolDoneAfterCreation()) {
                this.fireToolDone();
            }
        } else {
            super.mousePressed(e);
        }
    }

    @Override
    protected void creationFinished(Figure createdFigure) {
        this.getView().clearSelection();
        this.getView().addToSelection(createdFigure);
        this.beginEdit((TextHolderFigure)createdFigure);
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.createdFigure != null && this.rubberbandColor != null) {
            g.setColor(this.rubberbandColor);
            g.draw(this.getView().drawingToView(this.createdFigure.getBounds()));
        }
    }

    protected void beginEdit(TextHolderFigure textHolder) {
        if (this.textArea == null) {
            this.textArea = new FloatingTextArea();
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textArea.createOverlay(this.getView(), textHolder);
        this.textArea.setBounds(this.getFieldBounds(textHolder), textHolder.getText());
        this.textArea.requestFocus();
        this.typingTarget = textHolder;
    }

    private Rectangle2D.Double getFieldBounds(TextHolderFigure figure) {
        Rectangle2D.Double r = figure.getDrawingArea();
        Insets2D.Double insets = figure.getInsets();
        insets.subtractTo(r);
        r.x -= 1.0;
        r.y -= 2.0;
        r.width += 18.0;
        r.height += 4.0;
        return r;
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            this.typingTarget.willChange();
            final TextHolderFigure editedFigure = this.typingTarget;
            final String oldText = this.typingTarget.getText();
            final String newText = this.textArea.getText();
            if (newText.length() > 0) {
                this.typingTarget.setText(newText);
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
            }
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                public String getPresentationName() {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    return labels.getString("attribute.text.text");
                }

                public void undo() {
                    super.undo();
                    editedFigure.willChange();
                    editedFigure.setText(oldText);
                    editedFigure.changed();
                }

                public void redo() {
                    super.redo();
                    editedFigure.willChange();
                    editedFigure.setText(newText);
                    editedFigure.changed();
                }
            };
            this.getDrawing().fireUndoableEditHappened(edit);
            this.typingTarget.changed();
            this.typingTarget = null;
            this.textArea.endOverlay();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }
}

