/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GeometryEdit;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizeHandleKit {
    private static final boolean DEBUG = false;

    public static void addCornerResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(ResizeHandleKit.southEast(f));
        handles.add(ResizeHandleKit.southWest(f));
        handles.add(ResizeHandleKit.northEast(f));
        handles.add(ResizeHandleKit.northWest(f));
    }

    public static void addEdgeResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(ResizeHandleKit.south(f));
        handles.add(ResizeHandleKit.north(f));
        handles.add(ResizeHandleKit.east(f));
        handles.add(ResizeHandleKit.west(f));
    }

    public static void addResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(new BoundsOutlineHandle(f));
        ResizeHandleKit.addCornerResizeHandles(f, handles);
        ResizeHandleKit.addEdgeResizeHandles(f, handles);
    }

    public static Handle south(Figure owner) {
        return new SouthHandle(owner);
    }

    public static Handle southEast(Figure owner) {
        return new SouthEastHandle(owner);
    }

    public static Handle southWest(Figure owner) {
        return new SouthWestHandle(owner);
    }

    public static Handle north(Figure owner) {
        return new NorthHandle(owner);
    }

    public static Handle northEast(Figure owner) {
        return new NorthEastHandle(owner);
    }

    public static Handle northWest(Figure owner) {
        return new NorthWestHandle(owner);
    }

    public static Handle east(Figure owner) {
        return new EastHandle(owner);
    }

    public static Handle west(Figure owner) {
        return new WestHandle(owner);
    }

    private static class WestHandle
    extends ResizeHandle {
        WestHandle(Figure owner) {
            super(owner, RelativeLocator.west(true));
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        public void keyPressed(KeyEvent evt) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    evt.consume();
                    break;
                }
                case 40: {
                    evt.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 10 : 0);
        }
    }

    private static class SouthWestHandle
    extends ResizeHandle {
        SouthWestHandle(Figure owner) {
            super(owner, RelativeLocator.southWest(true));
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        public void keyPressed(KeyEvent evt) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 4 : 0);
        }
    }

    private static class SouthHandle
    extends ResizeHandle {
        SouthHandle(Figure owner) {
            super(owner, RelativeLocator.south(true));
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        public void keyPressed(KeyEvent evt) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    evt.consume();
                    break;
                }
                case 39: {
                    evt.consume();
                }
            }
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 9 : 0);
        }
    }

    private static class SouthEastHandle
    extends ResizeHandle {
        SouthEastHandle(Figure owner) {
            super(owner, RelativeLocator.southEast(true));
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), Math.max(r.y + 1.0, p.y)));
        }

        public void keyPressed(KeyEvent evt) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 5 : 0);
        }
    }

    private static class NorthWestHandle
    extends ResizeHandle {
        NorthWestHandle(Figure owner) {
            super(owner, RelativeLocator.northWest(true));
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        public void keyPressed(KeyEvent evt) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 6 : 0);
        }
    }

    private static class NorthHandle
    extends ResizeHandle {
        NorthHandle(Figure owner) {
            super(owner, RelativeLocator.north(true));
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        public void keyPressed(KeyEvent evt) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: {
                    evt.consume();
                    break;
                }
                case 39: {
                    evt.consume();
                }
            }
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 8 : 0);
        }
    }

    private static class EastHandle
    extends ResizeHandle {
        EastHandle(Figure owner) {
            super(owner, RelativeLocator.east(true));
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), r.y + r.height));
        }

        public void keyPressed(KeyEvent evt) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    evt.consume();
                    break;
                }
                case 40: {
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 11 : 0);
        }
    }

    private static class NorthEastHandle
    extends ResizeHandle {
        NorthEastHandle(Figure owner) {
            super(owner, RelativeLocator.northEast(true));
        }

        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(Math.max(r.x, p.x), r.y + r.height));
        }

        public void keyPressed(KeyEvent evt) {
            Rectangle2D.Double r = this.getOwner().getBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 7 : 0);
        }
    }

    private static class ResizeHandle
    extends LocatorHandle {
        private int dx;
        private int dy;
        Object geometry;

        ResizeHandle(Figure owner, Locator loc) {
            super(owner, loc);
        }

        public String getToolTipText(Point p) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            return labels.getString("handle.resize.toolTipText");
        }

        public void draw(Graphics2D g) {
            if (this.getEditor().getTool().supportsHandleInteraction()) {
                if (this.getOwner().isTransformable()) {
                    this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.RESIZE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.RESIZE_HANDLE_STROKE_COLOR));
                } else {
                    this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_STROKE_COLOR));
                }
            } else {
                this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_STROKE_COLOR_DISABLED));
            }
        }

        public void trackStart(Point anchor, int modifiersEx) {
            this.geometry = this.getOwner().getTransformRestoreData();
            Point location = this.getLocation();
            this.dx = -anchor.x + location.x;
            this.dy = -anchor.y + location.y;
        }

        public void trackStep(Point anchor, Point lead, int modifiersEx) {
            if (this.getOwner().isTransformable()) {
                Point2D.Double p = this.view.viewToDrawing(new Point(lead.x + this.dx, lead.y + this.dy));
                this.view.getConstrainer().constrainPoint(p);
                if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
                    try {
                        AttributeKeys.TRANSFORM.get(this.getOwner()).inverseTransform(p, p);
                    }
                    catch (NoninvertibleTransformException ex) {
                        // empty catch block
                    }
                }
                this.trackStepNormalized(p);
            }
        }

        public void trackEnd(Point anchor, Point lead, int modifiersEx) {
            if (this.getOwner().isTransformable()) {
                this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), this.geometry, this.getOwner().getTransformRestoreData()));
            }
        }

        protected void trackStepNormalized(Point2D.Double p) {
        }

        protected void setBounds(Point2D.Double anchor, Point2D.Double lead) {
            Figure f = this.getOwner();
            f.willChange();
            f.setBounds(anchor, lead);
            f.changed();
        }
    }
}

