/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.gui.datatransfer.ImageTransferable;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.Images;

public class ImageInputFormat
implements InputFormat {
    private ImageHolderFigure prototype;
    private String description;
    private String fileExtension;
    private String formatName;
    private int imageType;

    public ImageInputFormat(ImageHolderFigure prototype) {
        this(prototype, "PNG", "Portable Network Graphics (PNG)", "png", 2);
    }

    public ImageInputFormat(ImageHolderFigure prototype, String formatName, String description, String fileExtension, int bufferedImageType) {
        this.prototype = prototype;
        this.formatName = formatName;
        this.description = description;
        this.fileExtension = fileExtension;
        this.imageType = bufferedImageType;
    }

    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public JComponent getInputFormatAccessory() {
        return null;
    }

    public void read(File file, Drawing drawing, boolean replace) throws IOException {
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.loadImage(file);
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        if (replace) {
            drawing.removeAllChildren();
        }
        drawing.basicAdd(figure);
    }

    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    public void read(InputStream in, Drawing drawing, boolean replace) throws IOException {
        if (replace) {
            drawing.removeAllChildren();
        }
        drawing.basicAdd(this.createImageHolder(in));
    }

    public ImageHolderFigure createImageHolder(InputStream in) throws IOException {
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.loadImage(in);
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        return figure;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.imageFlavor) || flavor.equals(ImageTransferable.IMAGE_PNG_FLAVOR);
    }

    public void read(Transferable t, Drawing drawing, boolean replace) throws UnsupportedFlavorException, IOException {
        if (t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image img = (Image)t.getTransferData(DataFlavor.imageFlavor);
                img = Images.toBufferedImage(img);
                ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
                figure.setBufferedImage((BufferedImage)img);
                figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
                LinkedList<ImageHolderFigure> list = new LinkedList<ImageHolderFigure>();
                list.add(figure);
                if (replace) {
                    drawing.removeAllChildren();
                }
                drawing.addAll(list);
                return;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (t.isDataFlavorSupported(ImageTransferable.IMAGE_PNG_FLAVOR)) {
            try {
                InputStream in = (InputStream)t.getTransferData(ImageTransferable.IMAGE_PNG_FLAVOR);
                BufferedImage img = ImageIO.read(in);
                img = Images.toBufferedImage(img);
                ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
                figure.setBufferedImage(img);
                figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
                LinkedList<ImageHolderFigure> list = new LinkedList<ImageHolderFigure>();
                list.add(figure);
                if (replace) {
                    drawing.removeAllChildren();
                }
                drawing.addAll(list);
            }
            catch (Throwable e) {
                e.printStackTrace();
                IOException ex = new IOException("Couldn't import image as image/png flavor");
                ex.initCause(e);
                throw ex;
            }
        } else {
            throw new IOException("Couldn't import image.");
        }
    }
}

