/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractConstrainer;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.RotationDirection;
import org.jhotdraw.draw.TranslationDirection;

public class GridConstrainer
extends AbstractConstrainer {
    private double width;
    private double height;
    private double theta;
    private boolean isVisible;
    private static Color minorColor = new Color(0xEBEBEB);
    private static Color majorColor = new Color(0xCACACA);
    private int majorGridSpacing = 5;

    public GridConstrainer() {
        this(1.0, 1.0, 0.0, false);
    }

    public GridConstrainer(double width, double height) {
        this(width, height, 0.39269908169872414, true);
    }

    public GridConstrainer(double width, double height, boolean visible) {
        this(width, height, 0.39269908169872414, visible);
    }

    public GridConstrainer(double width, double height, double theta, boolean visible) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("Width or height is <= 0");
        }
        this.width = width;
        this.height = height;
        this.theta = theta;
        this.isVisible = visible;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getTheta() {
        return this.theta;
    }

    public void setWidth(double newValue) {
        double oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange("width", oldValue, newValue);
        this.fireStateChanged();
    }

    public void setHeight(double newValue) {
        double oldValue = this.height;
        this.height = newValue;
        this.firePropertyChange("height", oldValue, newValue);
        this.fireStateChanged();
    }

    public void setTheta(double newValue) {
        double oldValue = this.theta;
        this.theta = newValue;
        this.firePropertyChange("theta", oldValue, newValue);
        this.fireStateChanged();
    }

    public Point2D.Double constrainPoint(Point2D.Double p) {
        p.x = (double)Math.round(p.x / this.width) * this.width;
        p.y = (double)Math.round(p.y / this.height) * this.height;
        return p;
    }

    protected Point2D.Double constrainPoint(Point2D.Double p, TranslationDirection dir) {
        Point2D.Double p0 = this.constrainPoint((Point2D.Double)p.clone());
        switch (dir) {
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                if (p0.y < p.y) {
                    p.y = p0.y;
                    break;
                }
                if (!(p0.y > p.y)) break;
                p.y = p0.y - this.height;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                if (p0.y < p.y) {
                    p.y = p0.y + this.height;
                    break;
                }
                if (!(p0.y > p.y)) break;
                p.y = p0.y;
            }
        }
        switch (dir) {
            case NORTH_WEST: 
            case SOUTH_WEST: 
            case WEST: {
                if (p0.x < p.x) {
                    p.x = p0.x;
                    break;
                }
                if (!(p0.x > p.x)) break;
                p.x = p0.x - this.width;
                break;
            }
            case NORTH_EAST: 
            case SOUTH_EAST: 
            case EAST: {
                if (p0.x < p.x) {
                    p.x = p0.x + this.width;
                    break;
                }
                if (!(p0.x > p.x)) break;
                p.x = p0.x;
            }
        }
        return p;
    }

    public Point2D.Double translatePoint(Point2D.Double p, TranslationDirection dir) {
        Point2D.Double p0 = this.constrainPoint((Point2D.Double)p.clone());
        switch (dir) {
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                p.y = p0.y - this.height;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                p.y = p0.y + this.height;
            }
        }
        switch (dir) {
            case NORTH_WEST: 
            case SOUTH_WEST: 
            case WEST: {
                p.x = p0.x - this.width;
                break;
            }
            case NORTH_EAST: 
            case SOUTH_EAST: 
            case EAST: {
                p.x = p0.x + this.width;
            }
        }
        return p;
    }

    public Rectangle2D.Double constrainRectangle(Rectangle2D.Double r) {
        Point2D.Double p0 = this.constrainPoint(new Point2D.Double(r.x, r.y));
        Point2D.Double p1 = this.constrainPoint(new Point2D.Double(r.x + r.width, r.y + r.height));
        r.x = Math.abs(p0.x - r.x) < Math.abs(p1.x - r.x - r.width) ? p0.x : p1.x - r.width;
        r.y = Math.abs(p0.y - r.y) < Math.abs(p1.y - r.y - r.height) ? p0.y : p1.y - r.height;
        return r;
    }

    protected Rectangle2D.Double constrainRectangle(Rectangle2D.Double r, TranslationDirection dir) {
        Point2D.Double p0 = new Point2D.Double(r.x, r.y);
        switch (dir) {
            case NORTH: 
            case NORTH_WEST: 
            case WEST: {
                this.constrainPoint(p0, dir);
                break;
            }
            case NORTH_EAST: 
            case EAST: {
                p0.x += r.width;
                this.constrainPoint(p0, dir);
                p0.x -= r.width;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: {
                p0.y += r.height;
                this.constrainPoint(p0, dir);
                p0.y -= r.height;
                break;
            }
            case SOUTH_EAST: {
                p0.y += r.height;
                p0.x += r.width;
                this.constrainPoint(p0, dir);
                p0.y -= r.height;
                p0.x -= r.width;
            }
        }
        r.x = p0.x;
        r.y = p0.y;
        return r;
    }

    public Rectangle2D.Double translateRectangle(Rectangle2D.Double r, TranslationDirection dir) {
        double x = r.x;
        double y = r.y;
        this.constrainRectangle(r, dir);
        switch (dir) {
            case NORTH: 
            case NORTH_WEST: 
            case NORTH_EAST: {
                if (y != r.y) break;
                r.y -= this.height;
                break;
            }
            case SOUTH: 
            case SOUTH_WEST: 
            case SOUTH_EAST: {
                if (y != r.y) break;
                r.y += this.height;
            }
        }
        switch (dir) {
            case NORTH_WEST: 
            case SOUTH_WEST: 
            case WEST: {
                if (x != r.x) break;
                r.x -= this.width;
                break;
            }
            case NORTH_EAST: 
            case SOUTH_EAST: 
            case EAST: {
                if (x != r.x) break;
                r.x += this.width;
            }
        }
        return r;
    }

    public String toString() {
        return super.toString() + "[" + this.width + "," + this.height + "]";
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean newValue) {
        boolean oldValue = this.isVisible;
        this.isVisible = newValue;
        this.firePropertyChange("visible", oldValue, newValue);
        this.fireStateChanged();
    }

    public int getMajorGridSpacing() {
        return this.majorGridSpacing;
    }

    public void setMajorGridSpacing(int newValue) {
        int oldValue = this.majorGridSpacing;
        this.majorGridSpacing = newValue;
        this.firePropertyChange("majorGridSpacing", oldValue, newValue);
        this.fireStateChanged();
    }

    public void draw(Graphics2D g, DrawingView view) {
        block7: {
            int i;
            int m;
            Point2D.Double viewPoint;
            Point2D.Double point;
            Point2D.Double origin;
            Rectangle2D.Double bounds;
            Rectangle viewBounds;
            AffineTransform t;
            block8: {
                if (!this.isVisible) break block7;
                t = view.getDrawingToViewTransform();
                viewBounds = g.getClipBounds();
                bounds = view.viewToDrawing(viewBounds);
                origin = this.constrainPoint(new Point2D.Double(bounds.x, bounds.y));
                point = new Point2D.Double();
                viewPoint = new Point2D.Double();
                if (this.width * view.getScaleFactor() > 2.0) {
                    g.setColor(minorColor);
                    m = (int)((origin.x + bounds.width) / this.width) + 1;
                    for (i = (int)(origin.x / this.width); i <= m; ++i) {
                        g.setColor(i % this.majorGridSpacing == 0 ? majorColor : minorColor);
                        point.x = this.width * (double)i;
                        t.transform(point, viewPoint);
                        g.drawLine((int)viewPoint.x, viewBounds.y, (int)viewPoint.x, viewBounds.y + viewBounds.height);
                    }
                } else if (this.width * (double)this.majorGridSpacing * view.getScaleFactor() > 2.0) {
                    g.setColor(majorColor);
                    m = (int)((origin.x + bounds.width) / this.width) + 1;
                    for (i = (int)(origin.x / this.width); i <= m; ++i) {
                        if (i % this.majorGridSpacing != 0) continue;
                        point.x = this.width * (double)i;
                        t.transform(point, viewPoint);
                        g.drawLine((int)viewPoint.x, viewBounds.y, (int)viewPoint.x, viewBounds.y + viewBounds.height);
                    }
                }
                if (!(this.height * view.getScaleFactor() > 2.0)) break block8;
                g.setColor(minorColor);
                m = (int)((origin.y + bounds.height) / this.height) + 1;
                for (i = (int)(origin.y / this.height); i <= m; ++i) {
                    g.setColor(i % this.majorGridSpacing == 0 ? majorColor : minorColor);
                    point.y = this.height * (double)i;
                    t.transform(point, viewPoint);
                    g.drawLine(viewBounds.x, (int)viewPoint.y, viewBounds.x + viewBounds.width, (int)viewPoint.y);
                }
                break block7;
            }
            if (!(this.height * (double)this.majorGridSpacing * view.getScaleFactor() > 2.0)) break block7;
            g.setColor(majorColor);
            m = (int)((origin.y + bounds.height) / this.height) + 1;
            for (i = (int)(origin.y / this.height); i <= m; ++i) {
                if (i % this.majorGridSpacing != 0) continue;
                point.y = this.height * (double)i;
                t.transform(point, viewPoint);
                g.drawLine(viewBounds.x, (int)viewPoint.y, viewBounds.x + viewBounds.width, (int)viewPoint.y);
            }
        }
    }

    public double constrainAngle(double angle) {
        if (this.theta == 0.0) {
            return angle;
        }
        double factor = Math.round(angle / this.theta);
        return this.theta * factor;
    }

    public double rotateAngle(double angle, RotationDirection dir) {
        if (dir == null) {
            throw new IllegalArgumentException("dir must not be null");
        }
        angle = this.constrainAngle(angle);
        switch (dir) {
            case CLOCKWISE: {
                angle += this.theta;
                break;
            }
            default: {
                angle -= this.theta;
            }
        }
        return angle;
    }
}

