/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleMulticaster;
import org.jhotdraw.draw.HandleTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHandleTracker
extends AbstractTool
implements HandleTracker {
    private Handle masterHandle;
    private HandleMulticaster multicaster;
    private LinkedList<Handle> hoverHandles = new LinkedList();
    private Figure hoverFigure = null;

    public DefaultHandleTracker(Handle handle) {
        this.masterHandle = handle;
        this.multicaster = new HandleMulticaster(handle);
    }

    public DefaultHandleTracker(Handle master, Collection<Handle> handles) {
        this.masterHandle = master;
        this.multicaster = new HandleMulticaster(handles);
    }

    public DefaultHandleTracker() {
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.hoverHandles.size() > 0 && !this.getView().isFigureSelected(this.hoverFigure)) {
            for (Handle h : this.hoverHandles) {
                h.draw(g);
            }
        }
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.getView().setCursor(this.masterHandle.getCursor());
        this.getView().setActiveHandle(this.masterHandle);
        this.clearHoverHandles();
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        this.getView().setCursor(Cursor.getDefaultCursor());
        this.getView().setActiveHandle(null);
        this.clearHoverHandles();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        this.multicaster.keyPressed(evt);
        if (!evt.isConsumed()) {
            super.keyPressed(evt);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        this.multicaster.keyReleased(evt);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        this.multicaster.keyTyped(evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.multicaster.trackDoubleClick(new Point(evt.getX(), evt.getY()), evt.getModifiersEx(), this.getView());
        }
        evt.consume();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.multicaster.trackStep(this.anchor, new Point(evt.getX(), evt.getY()), evt.getModifiersEx(), this.getView());
        this.clearHoverHandles();
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        DrawingView view = this.editor.findView((Container)evt.getSource());
        this.updateHoverHandles(view, null);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        Point point = evt.getPoint();
        this.updateCursor(this.editor.findView((Container)evt.getSource()), point);
        DrawingView view = this.editor.findView((Container)evt.getSource());
        this.updateCursor(view, point);
        if (view == null || this.editor.getActiveView() != view) {
            this.clearHoverHandles();
        } else {
            Figure figure = null;
            Point2D.Double p = view.viewToDrawing(point);
            for (Figure f : view.getSelectedFigures()) {
                if (!f.contains(p)) continue;
                figure = f;
            }
            if (figure == null) {
                figure = view.findFigure(point);
                Drawing drawing = view.getDrawing();
                while (figure != null && !figure.isSelectable()) {
                    figure = drawing.findFigureBehind(p, figure);
                }
            }
            this.updateHoverHandles(view, figure);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.anchor = new Point(evt.getX(), evt.getY());
        this.multicaster.trackStart(this.anchor, evt.getModifiersEx(), this.getView());
        this.clearHoverHandles();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.multicaster.trackEnd(this.anchor, new Point(evt.getX(), evt.getY()), evt.getModifiersEx(), this.getView());
        this.fireToolDone();
    }

    protected void clearHoverHandles() {
        this.updateHoverHandles(null, null);
    }

    protected void updateHoverHandles(DrawingView view, Figure f) {
        if (f != this.hoverFigure) {
            Rectangle r = null;
            if (this.hoverFigure != null && this.hoverFigure.isSelectable()) {
                for (Handle h : this.hoverHandles) {
                    if (r == null) {
                        r = h.getDrawingArea();
                    } else {
                        r.add(h.getDrawingArea());
                    }
                    h.setView(null);
                    h.dispose();
                }
                this.hoverHandles.clear();
            }
            this.hoverFigure = f;
            if (this.hoverFigure != null) {
                this.hoverHandles.addAll(this.hoverFigure.createHandles(-1));
                for (Handle h : this.hoverHandles) {
                    h.setView(view);
                    if (r == null) {
                        r = h.getDrawingArea();
                        continue;
                    }
                    r.add(h.getDrawingArea());
                }
            }
            if (r != null) {
                r.grow(1, 1);
                this.fireAreaInvalidated(r);
            }
        }
    }

    @Override
    public void setHandles(Handle handle, Collection<Handle> compatibleHandles) {
        this.masterHandle = handle;
        this.multicaster = new HandleMulticaster(handle);
    }
}

