/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.CompositeFigureEvent;
import org.jhotdraw.draw.CompositeFigureListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.datatransfer.CompositeTransferable;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDrawingViewTransferHandler
extends TransferHandler {
    private static final boolean DEBUG = false;
    private HashSet<Figure> exportedFigures;

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        return this.importData(comp, t, new HashSet<Figure>());
    }

    protected boolean importData(JComponent comp, Transferable t, HashSet<Figure> transferFigures) {
        boolean retValue;
        if (comp instanceof DrawingView) {
            final DrawingView view = (DrawingView)((Object)comp);
            final Drawing drawing = view.getDrawing();
            if (drawing.getInputFormats() == null || drawing.getInputFormats().size() == 0) {
                retValue = false;
            } else {
                retValue = false;
                try {
                    block2: for (InputFormat format : drawing.getInputFormats()) {
                        for (DataFlavor flavor : t.getTransferDataFlavors()) {
                            if (!format.isDataFlavorSupported(flavor)) continue;
                            LinkedList<Figure> existingFigures = new LinkedList<Figure>(drawing.getChildren());
                            format.read(t, drawing, false);
                            final LinkedList<Figure> importedFigures = new LinkedList<Figure>(drawing.getChildren());
                            importedFigures.removeAll(existingFigures);
                            view.clearSelection();
                            view.addToSelection(importedFigures);
                            transferFigures.addAll(importedFigures);
                            drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                                public String getPresentationName() {
                                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                                    return labels.getString("edit.paste.text");
                                }

                                public void undo() throws CannotUndoException {
                                    super.undo();
                                    drawing.removeAll(importedFigures);
                                }

                                public void redo() throws CannotRedoException {
                                    super.redo();
                                    drawing.addAll(importedFigures);
                                }
                            });
                            retValue = true;
                            break block2;
                        }
                    }
                    if (!retValue && t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        final List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        retValue = true;
                        final LinkedList<Figure> existingFigures = new LinkedList<Figure>(drawing.getChildren());
                        view.getEditor().setEnabled(false);
                        new Worker(){

                            public Object construct() {
                                try {
                                    for (File file : files) {
                                        for (InputFormat format : drawing.getInputFormats()) {
                                            if (!file.isFile() || !format.getFileFilter().accept(file)) continue;
                                            format.read(file, drawing, false);
                                        }
                                    }
                                    return new LinkedList<Figure>(drawing.getChildren());
                                }
                                catch (Throwable t) {
                                    return t;
                                }
                            }

                            public void finished(Object value) {
                                if (value instanceof Throwable) {
                                    ((Throwable)value).printStackTrace();
                                } else {
                                    final LinkedList importedFigures = (LinkedList)value;
                                    importedFigures.removeAll(existingFigures);
                                    if (importedFigures.size() > 0) {
                                        view.clearSelection();
                                        view.addToSelection(importedFigures);
                                        drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                                            public String getPresentationName() {
                                                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                                                return labels.getString("edit.paste.text");
                                            }

                                            public void undo() throws CannotUndoException {
                                                super.undo();
                                                drawing.removeAll(importedFigures);
                                            }

                                            public void redo() throws CannotRedoException {
                                                super.redo();
                                                drawing.addAll(importedFigures);
                                            }
                                        });
                                    }
                                }
                                view.getEditor().setEnabled(true);
                            }
                        }.start();
                    }
                }
                catch (Throwable e) {}
            }
        } else {
            retValue = super.importData(comp, t);
        }
        return retValue;
    }

    @Override
    public int getSourceActions(JComponent c) {
        DrawingView view;
        int retValue = c instanceof DrawingView ? ((view = (DrawingView)((Object)c)).getDrawing().getOutputFormats().size() > 0 && view.getSelectionCount() > 0 ? 3 : 0) : super.getSourceActions(c);
        return retValue;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        Transferable retValue;
        if (c instanceof DrawingView) {
            DrawingView view = (DrawingView)((Object)c);
            retValue = this.createTransferable(view, view.getSelectedFigures());
        } else {
            retValue = super.createTransferable(c);
        }
        return retValue;
    }

    protected Transferable createTransferable(DrawingView view, Set<Figure> transferFigures) {
        CompositeTransferable retValue;
        Drawing drawing = view.getDrawing();
        if (drawing.getOutputFormats() == null || drawing.getOutputFormats().size() == 0) {
            retValue = null;
        } else {
            List<Figure> toBeCopied = drawing.sort(transferFigures);
            if (toBeCopied.size() > 0) {
                try {
                    CompositeTransferable transfer = new CompositeTransferable();
                    for (OutputFormat format : drawing.getOutputFormats()) {
                        Transferable t = format.createTransferable(drawing, toBeCopied, view.getScaleFactor());
                        if (transfer.isDataFlavorSupported(t.getTransferDataFlavors()[0])) continue;
                        transfer.add(t);
                    }
                    retValue = transfer;
                }
                catch (IOException e) {
                    retValue = null;
                }
            } else {
                retValue = null;
            }
        }
        return retValue;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (source instanceof DrawingView) {
            final DrawingView view = (DrawingView)((Object)source);
            final Drawing drawing = view.getDrawing();
            if (action == 2) {
                final LinkedList deletionEvents = new LinkedList();
                final LinkedList<Figure> selectedFigures = new LinkedList<Figure>(this.exportedFigures);
                for (Figure f : selectedFigures) {
                    if (f.isRemovable()) continue;
                    source.getToolkit().beep();
                    return;
                }
                CompositeFigureListener removeListener = new CompositeFigureListener(){

                    public void areaInvalidated(CompositeFigureEvent e) {
                    }

                    public void figureAdded(CompositeFigureEvent e) {
                    }

                    public void figureRemoved(CompositeFigureEvent evt) {
                        deletionEvents.addFirst(evt);
                    }
                };
                drawing.addCompositeFigureListener(removeListener);
                drawing.removeAll(selectedFigures);
                drawing.removeCompositeFigureListener(removeListener);
                drawing.removeAll(selectedFigures);
                drawing.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                        return labels.getString("edit.delete.text");
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        view.clearSelection();
                        for (CompositeFigureEvent evt : deletionEvents) {
                            drawing.add(evt.getIndex(), evt.getChildFigure());
                        }
                        view.addToSelection(selectedFigures);
                    }

                    public void redo() throws CannotRedoException {
                        super.redo();
                        for (CompositeFigureEvent evt : new ReversedList(deletionEvents)) {
                            drawing.remove(evt.getChildFigure());
                        }
                    }
                });
            }
        } else {
            super.exportDone(source, data, action);
        }
        this.exportedFigures = null;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        if (comp instanceof DrawingView) {
            DrawingView view = (DrawingView)((Object)comp);
            HashSet<Figure> transferFigures = new HashSet<Figure>();
            this.exportedFigures = transferFigures;
            MouseEvent me = (MouseEvent)e;
            Figure f = view.findFigure(me.getPoint());
            if (view.getSelectedFigures().contains(f)) {
                transferFigures.addAll(view.getSelectedFigures());
            } else {
                transferFigures.add(f);
            }
            Rectangle2D.Double drawingArea = null;
            for (Figure fig : transferFigures) {
                if (drawingArea == null) {
                    drawingArea = fig.getDrawingArea();
                    continue;
                }
                drawingArea.add(fig.getDrawingArea());
            }
            Rectangle viewArea = view.drawingToView(drawingArea);
            Point imageOffset = me.getPoint();
            imageOffset.x = viewArea.x - imageOffset.x;
            imageOffset.y = viewArea.y - imageOffset.y;
            int srcActions = this.getSourceActions(comp);
            SwingDragGestureRecognizer recognizer = new SwingDragGestureRecognizer(new DragHandler(this.createTransferable(view, transferFigures), imageOffset));
            recognizer.gestured(comp, me, srcActions, action);
        } else {
            super.exportAsDrag(comp, e, action);
        }
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        Image image = null;
        try {
            image = (Image)t.getTransferData(DataFlavor.imageFlavor);
        }
        catch (IOException ex) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return image == null ? null : new ImageIcon(image);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        boolean retValue;
        block4: {
            if (comp instanceof DrawingView) {
                DrawingView view = (DrawingView)((Object)comp);
                Drawing drawing = view.getDrawing();
                retValue = false;
                for (InputFormat format : drawing.getInputFormats()) {
                    for (DataFlavor flavor : transferFlavors) {
                        if (!flavor.isFlavorJavaFileListType() && !format.isDataFlavorSupported(flavor)) continue;
                        retValue = true;
                        break block4;
                    }
                }
            } else {
                retValue = super.canImport(comp, transferFlavors);
            }
        }
        return retValue;
    }

    private void getDrawing() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;
        private Transferable transferable;
        private Point imageOffset;

        public DragHandler(Transferable t, Point imageOffset) {
            this.transferable = t;
            this.imageOffset = imageOffset;
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            DefaultDrawingViewTransferHandler th = (DefaultDrawingViewTransferHandler)c.getTransferHandler();
            Transferable t = this.transferable;
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    Image dragImage;
                    Icon icon = th.getVisualRepresentation(t);
                    if (icon instanceof ImageIcon) {
                        dragImage = ((ImageIcon)icon).getImage();
                    } else {
                        dragImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                        Graphics2D g = ((BufferedImage)dragImage).createGraphics();
                        icon.paintIcon(c, g, 0, 0);
                        g.dispose();
                    }
                    dge.startDrag(null, dragImage, this.imageOffset, t, this);
                    return;
                }
                catch (RuntimeException re) {
                    c.setAutoscrolls(this.scrolls);
                }
            }
            th.exportDone(c, t, 0);
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dsde) {
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            DefaultDrawingViewTransferHandler th = (DefaultDrawingViewTransferHandler)c.getTransferHandler();
            if (dsde.getDropSuccess()) {
                th.exportDone(c, dsc.getTransferable(), dsde.getDropAction());
            } else {
                th.exportDone(c, dsc.getTransferable(), 0);
            }
            c.setAutoscrolls(this.scrolls);
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }
}

