/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.util.ReversedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDrawing
extends AbstractDrawing {
    private boolean needsSorting = false;
    private Dimension2DDouble canvasSize;

    @Override
    public void basicAdd(int index, Figure figure) {
        super.basicAdd(index, figure);
        this.invalidateSortOrder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics2D g) {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureSorted();
            ArrayList<Figure> toDraw = new ArrayList<Figure>(this.getChildren().size());
            Rectangle clipRect = g.getClipBounds();
            for (Figure f : this.getChildren()) {
                if (!f.getDrawingArea().intersects(clipRect)) continue;
                toDraw.add(f);
            }
            this.draw(g, toDraw);
        }
    }

    public void draw(Graphics2D g, Collection<Figure> children) {
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds != null) {
            for (Figure f : children) {
                if (!f.isVisible() || !f.getDrawingArea().intersects(clipBounds)) continue;
                f.draw(g);
            }
        } else {
            for (Figure f : children) {
                if (!f.isVisible()) continue;
                f.draw(g);
            }
        }
    }

    @Override
    public List<Figure> sort(Collection<? extends Figure> c) {
        HashSet<? extends Figure> unsorted = new HashSet<Figure>();
        unsorted.addAll(c);
        ArrayList<Figure> sorted = new ArrayList<Figure>(c.size());
        for (Figure figure : this.getChildren()) {
            if (!unsorted.contains(figure)) continue;
            sorted.add(figure);
            unsorted.remove(figure);
        }
        for (Figure figure : c) {
            if (!unsorted.contains(figure)) continue;
            sorted.add(figure);
            unsorted.remove(figure);
        }
        return sorted;
    }

    @Override
    public Figure findFigure(Point2D.Double p) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Figure ignore) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (f == ignore || !f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double p, Figure figure) {
        boolean isBehind = false;
        for (Figure f : this.getFiguresFrontToBack()) {
            if (isBehind) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            isBehind = figure == f;
        }
        return null;
    }

    @Override
    public Figure findFigureBehind(Point2D.Double p, Collection<? extends Figure> children) {
        int inFrontOf = children.size();
        for (Figure f : this.getFiguresFrontToBack()) {
            if (inFrontOf == 0) {
                if (!f.isVisible() || !f.contains(p)) continue;
                return f;
            }
            if (!children.contains(f)) continue;
            --inFrontOf;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Collection<? extends Figure> ignore) {
        for (Figure f : this.getFiguresFrontToBack()) {
            if (ignore.contains(f) || !f.isVisible() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public List<Figure> findFigures(Rectangle2D.Double bounds) {
        LinkedList<Figure> intersection = new LinkedList<Figure>();
        for (Figure f : this.getChildren()) {
            if (!f.isVisible() || !f.getBounds().intersects(bounds)) continue;
            intersection.add(f);
        }
        return intersection;
    }

    @Override
    public List<Figure> findFiguresWithin(Rectangle2D.Double bounds) {
        LinkedList<Figure> contained = new LinkedList<Figure>();
        for (Figure f : this.getChildren()) {
            Rectangle2D.Double r = f.getBounds();
            if (AttributeKeys.TRANSFORM.get(f) != null) {
                Rectangle2D rt = AttributeKeys.TRANSFORM.get(f).createTransformedShape(r).getBounds2D();
                Rectangle2D.Double double_ = r = rt instanceof Rectangle2D.Double ? (Rectangle2D.Double)rt : new Rectangle2D.Double(rt.getX(), rt.getY(), rt.getWidth(), rt.getHeight());
            }
            if (!f.isVisible() || !Geom.contains(bounds, r)) continue;
            contained.add(f);
        }
        return contained;
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        Figure f = this.findFigure(p);
        return f == null ? null : f.findFigureInside(p);
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.getChildren());
    }

    private void invalidateSortOrder() {
        this.needsSorting = true;
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.children, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }

    protected void setAttributeOnChildren(AttributeKey key, Object newValue) {
    }

    public void setCanvasSize(Dimension2DDouble newValue) {
        Dimension2DDouble oldValue = this.canvasSize;
        this.canvasSize = newValue == null ? null : (Dimension2DDouble)newValue.clone();
        this.firePropertyChange("canvasSize", oldValue, newValue);
    }

    public Dimension2DDouble getCanvasSize() {
        return this.canvasSize == null ? null : (Dimension2DDouble)this.canvasSize.clone();
    }

    @Override
    public int indexOf(Figure figure) {
        return this.children.indexOf(figure);
    }

    @Override
    public DefaultDrawing clone() {
        DefaultDrawing that = (DefaultDrawing)super.clone();
        that.canvasSize = this.canvasSize == null ? null : (Dimension2DDouble)this.canvasSize.clone();
        return that;
    }

    @Override
    protected void drawFill(Graphics2D g) {
    }

    @Override
    protected void drawStroke(Graphics2D g) {
    }
}

