/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DragTracker;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;

public class DefaultDragTracker
extends AbstractTool
implements DragTracker {
    protected Figure anchorFigure;
    protected Rectangle2D.Double dragRect;
    protected Point2D.Double previousOrigin;
    protected Point2D.Double anchorOrigin;
    protected Point2D.Double previousPoint;
    protected Point2D.Double anchorPoint;
    private boolean isDragging;

    public DefaultDragTracker(Figure figure) {
        this.anchorFigure = figure;
    }

    public DefaultDragTracker() {
    }

    public void mouseMoved(MouseEvent evt) {
        this.updateCursor(this.editor.findView((Container)evt.getSource()), evt.getPoint());
    }

    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        DrawingView view = this.getView();
        if (evt.isShiftDown()) {
            view.setHandleDetailLevel(0);
            view.toggleSelection(this.anchorFigure);
            if (!view.isFigureSelected(this.anchorFigure)) {
                this.anchorFigure = null;
            }
        } else if (!view.isFigureSelected(this.anchorFigure)) {
            view.setHandleDetailLevel(0);
            view.clearSelection();
            view.addToSelection(this.anchorFigure);
        }
        if (!view.getSelectedFigures().isEmpty()) {
            this.dragRect = null;
            for (Figure f : view.getSelectedFigures()) {
                if (this.dragRect == null) {
                    this.dragRect = f.getBounds();
                    continue;
                }
                this.dragRect.add(f.getBounds());
            }
            this.anchorPoint = this.previousPoint = view.viewToDrawing(this.anchor);
            this.anchorOrigin = this.previousOrigin = new Point2D.Double(this.dragRect.x, this.dragRect.y);
        }
    }

    public void mouseDragged(MouseEvent evt) {
        DrawingView view = this.getView();
        if (!view.getSelectedFigures().isEmpty()) {
            if (!this.isDragging) {
                this.isDragging = true;
                this.updateCursor(this.editor.findView((Container)evt.getSource()), new Point(evt.getX(), evt.getY()));
            }
            Point2D.Double currentPoint = view.viewToDrawing(new Point(evt.getX(), evt.getY()));
            this.dragRect.x += currentPoint.x - this.previousPoint.x;
            this.dragRect.y += currentPoint.y - this.previousPoint.y;
            Rectangle2D.Double constrainedRect = (Rectangle2D.Double)this.dragRect.clone();
            if (view.getConstrainer() != null) {
                view.getConstrainer().constrainRectangle(constrainedRect);
            }
            AffineTransform tx = new AffineTransform();
            tx.translate(constrainedRect.x - this.previousOrigin.x, constrainedRect.y - this.previousOrigin.y);
            Constrainer c = view.getConstrainer();
            for (Figure f : view.getSelectedFigures()) {
                f.willChange();
                f.transform(tx);
                f.changed();
            }
            this.previousPoint = currentPoint;
            this.previousOrigin = new Point2D.Double(constrainedRect.x, constrainedRect.y);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        super.mouseReleased(evt);
        DrawingView view = this.getView();
        if (!view.getSelectedFigures().isEmpty()) {
            boolean snapBack;
            this.isDragging = false;
            int x = evt.getX();
            int y = evt.getY();
            this.updateCursor(this.editor.findView((Container)evt.getSource()), new Point(x, y));
            Point2D.Double newPoint = view.viewToDrawing(new Point(x, y));
            LinkedList<Figure> draggedFigures = new LinkedList<Figure>(view.getSelectedFigures());
            Figure dropTarget = this.getDrawing().findFigureExcept(newPoint, draggedFigures);
            if (dropTarget != null && (snapBack = dropTarget.handleDrop(newPoint, draggedFigures, view))) {
                AffineTransform tx = new AffineTransform();
                tx.translate(this.anchorOrigin.x - this.previousOrigin.x, this.anchorOrigin.y - this.previousOrigin.y);
                Constrainer c = view.getConstrainer();
                for (Figure f : draggedFigures) {
                    f.willChange();
                    f.transform(tx);
                    f.changed();
                }
                this.fireToolDone();
                return;
            }
            AffineTransform tx = new AffineTransform();
            tx.translate(-this.anchorOrigin.x + this.previousOrigin.x, -this.anchorOrigin.y + this.previousOrigin.y);
            if (!tx.isIdentity()) {
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(draggedFigures, tx));
            }
        }
        this.fireToolDone();
    }

    public void setDraggedFigure(Figure f) {
        this.anchorFigure = f;
    }
}

