/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.HandleAttributeKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundsOutlineHandle
extends AbstractHandle {
    private AttributeKey<Stroke> stroke1Enabled;
    private AttributeKey<Stroke> stroke2Enabled;
    private AttributeKey<Stroke> stroke1Disabled;
    private AttributeKey<Stroke> stroke2Disabled;
    private AttributeKey<Color> strokeColor1Enabled;
    private AttributeKey<Color> strokeColor2Enabled;
    private AttributeKey<Color> strokeColor1Disabled;
    private AttributeKey<Color> strokeColor2Disabled;

    public BoundsOutlineHandle(Figure owner) {
        this(owner, false, false);
    }

    public BoundsOutlineHandle(Figure owner, boolean isTransformHandle, boolean isHoverHandle) {
        super(owner);
        if (isTransformHandle) {
            if (isHoverHandle) {
                this.stroke1Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_1_HOVER;
                this.strokeColor1Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_1_HOVER;
                this.stroke2Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_2_HOVER;
                this.strokeColor2Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_2_HOVER;
            } else {
                this.stroke1Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_1;
                this.strokeColor1Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_1;
                this.stroke2Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_2;
                this.strokeColor2Enabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_2;
            }
            this.stroke1Disabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_1_DISABLED;
            this.strokeColor1Disabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_1_DISABLED;
            this.stroke2Disabled = HandleAttributeKeys.TRANSFORM_BOUNDS_STROKE_2_DISABLED;
            this.strokeColor2Disabled = HandleAttributeKeys.TRANSFORM_BOUNDS_COLOR_2_DISABLED;
        } else {
            if (isHoverHandle) {
                this.stroke1Enabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_1_HOVER;
                this.strokeColor1Enabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_1_HOVER;
                this.stroke2Enabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_2_HOVER;
                this.strokeColor2Enabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_2_HOVER;
            } else {
                this.stroke1Enabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_1;
                this.strokeColor1Enabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_1;
                this.stroke2Enabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_2;
                this.strokeColor2Enabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_2;
            }
            this.stroke1Disabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_1_DISABLED;
            this.strokeColor1Disabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_1_DISABLED;
            this.stroke2Disabled = HandleAttributeKeys.RESIZE_BOUNDS_STROKE_2_DISABLED;
            this.strokeColor2Disabled = HandleAttributeKeys.RESIZE_BOUNDS_COLOR_2_DISABLED;
        }
    }

    public BoundsOutlineHandle(Figure owner, AttributeKey<Stroke> stroke1Enabled, AttributeKey<Color> strokeColor1Enabled, AttributeKey<Stroke> stroke2Enabled, AttributeKey<Color> strokeColor2Enabled, AttributeKey<Stroke> stroke1Disabled, AttributeKey<Color> strokeColor1Disabled, AttributeKey<Stroke> stroke2Disabled, AttributeKey<Color> strokeColor2Disabled) {
        super(owner);
        this.stroke1Enabled = stroke1Enabled;
        this.strokeColor1Enabled = strokeColor1Enabled;
        this.stroke2Enabled = stroke2Enabled;
        this.strokeColor2Enabled = strokeColor2Enabled;
        this.stroke1Disabled = stroke1Disabled;
        this.strokeColor1Disabled = strokeColor1Disabled;
        this.stroke2Disabled = stroke2Disabled;
        this.strokeColor2Disabled = strokeColor2Disabled;
    }

    @Override
    protected Rectangle basicGetBounds() {
        Shape bounds = this.getOwner().getBounds();
        if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
            bounds = AttributeKeys.TRANSFORM.get(this.getOwner()).createTransformedShape(bounds);
        }
        bounds = this.view.getDrawingToViewTransform().createTransformedShape(bounds);
        Rectangle r = bounds.getBounds();
        r.grow(2, 2);
        return r;
    }

    @Override
    public boolean contains(Point p) {
        return false;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public void draw(Graphics2D g) {
        Color strokeColor2;
        Stroke stroke2;
        Color strokeColor1;
        Stroke stroke1;
        Shape bounds = this.getOwner().getBounds();
        if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
            bounds = AttributeKeys.TRANSFORM.get(this.getOwner()).createTransformedShape(bounds);
        }
        bounds = this.view.getDrawingToViewTransform().createTransformedShape(bounds);
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            stroke1 = this.getEditor().getHandleAttribute(this.stroke1Enabled);
            strokeColor1 = this.getEditor().getHandleAttribute(this.strokeColor1Enabled);
            stroke2 = this.getEditor().getHandleAttribute(this.stroke2Enabled);
            strokeColor2 = this.getEditor().getHandleAttribute(this.strokeColor2Enabled);
        } else {
            stroke1 = this.getEditor().getHandleAttribute(this.stroke1Disabled);
            strokeColor1 = this.getEditor().getHandleAttribute(this.strokeColor1Disabled);
            stroke2 = this.getEditor().getHandleAttribute(this.stroke2Disabled);
            strokeColor2 = this.getEditor().getHandleAttribute(this.strokeColor2Disabled);
        }
        if (stroke1 != null && strokeColor1 != null) {
            g.setStroke(stroke1);
            g.setColor(strokeColor1);
            g.draw(bounds);
        }
        if (stroke2 != null && strokeColor2 != null) {
            g.setStroke(stroke2);
            g.setColor(strokeColor2);
            g.draw(bounds);
        }
    }
}

