/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.util.ResourceBundleUtil;

public class AttributeKeys {
    private static final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
    public static final AttributeKey<Color> CANVAS_FILL_COLOR = new AttributeKey<Color>("canvasFillColor", Color.class, Color.white, true, labels);
    public static final AttributeKey<Double> CANVAS_FILL_OPACITY = new AttributeKey<Double>("canvasFillOpacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<Double> CANVAS_WIDTH = new AttributeKey<Object>("canvasWidth", Double.class, null, true, labels);
    public static final AttributeKey<Double> CANVAS_HEIGHT = new AttributeKey<Object>("canvasHeight", Double.class, null, true, labels);
    public static final AttributeKey<Color> FILL_COLOR = new AttributeKey<Color>("fillColor", Color.class, Color.white, true, labels);
    public static final AttributeKey<Boolean> CLOSED = new AttributeKey<Boolean>("closed", Boolean.class, false, false, labels);
    public static final AttributeKey<Boolean> FILL_OPEN_PATH = new AttributeKey<Boolean>("fillOpenPath", Boolean.class, false, false, labels);
    public static final AttributeKey<WindingRule> WINDING_RULE = new AttributeKey<WindingRule>("windingRule", WindingRule.class, WindingRule.EVEN_ODD, false, labels);
    public static final AttributeKey<Underfill> FILL_UNDER_STROKE = new AttributeKey<Underfill>("fillUnderStroke", Underfill.class, Underfill.CENTER, false, labels);
    public static final AttributeKey<Color> STROKE_COLOR = new AttributeKey<Color>("strokeColor", Color.class, Color.black, true, labels);
    public static final AttributeKey<Double> STROKE_WIDTH = new AttributeKey<Double>("strokeWidth", Double.class, 1.0, false, labels);
    public static final AttributeKey<Double> STROKE_INNER_WIDTH_FACTOR = new AttributeKey<Double>("innerStrokeWidthFactor", Double.class, 2.0, false, labels);
    public static final AttributeKey<Integer> STROKE_JOIN = new AttributeKey<Integer>("strokeJoin", Integer.class, 0, false, labels);
    public static final AttributeKey<Integer> STROKE_CAP = new AttributeKey<Integer>("strokeCap", Integer.class, 0, false, labels);
    public static final AttributeKey<Double> STROKE_MITER_LIMIT = new AttributeKey<Double>("strokeMiterLimitFactor", Double.class, 3.0, false, labels);
    public static final AttributeKey<Boolean> IS_STROKE_MITER_LIMIT_FACTOR = new AttributeKey<Boolean>("isStrokeMiterLimitFactor", Boolean.class, true, false, labels);
    public static final AttributeKey<double[]> STROKE_DASHES = new AttributeKey<Object>("strokeDashes", double[].class, null, true, labels);
    public static final AttributeKey<Double> STROKE_DASH_PHASE = new AttributeKey<Double>("strokeDashPhase", Double.class, 0.0, false, labels);
    public static final AttributeKey<Boolean> IS_STROKE_DASH_FACTOR = new AttributeKey<Boolean>("isStrokeDashFactor", Boolean.class, true, false, labels);
    public static final AttributeKey<StrokeType> STROKE_TYPE = new AttributeKey<StrokeType>("strokeType", StrokeType.class, StrokeType.BASIC, false, labels);
    public static final AttributeKey<StrokePlacement> STROKE_PLACEMENT = new AttributeKey<StrokePlacement>("strokePlacement", StrokePlacement.class, StrokePlacement.CENTER, false, labels);
    public static final AttributeKey<String> TEXT = new AttributeKey<Object>("text", String.class, null, true, labels);
    public static final AttributeKey<Color> TEXT_COLOR = new AttributeKey<Color>("textColor", Color.class, Color.BLACK, false, labels);
    public static final AttributeKey<Color> TEXT_SHADOW_COLOR = new AttributeKey<Object>("textShadowColor", Color.class, null, true, labels);
    public static final AttributeKey<Dimension2DDouble> TEXT_SHADOW_OFFSET = new AttributeKey<Dimension2DDouble>("textShadowOffset", Dimension2DDouble.class, new Dimension2DDouble(1.0, 1.0), false, labels);
    public static final AttributeKey<Alignment> TEXT_ALIGNMENT = new AttributeKey<Alignment>("textAlignment", Alignment.class, Alignment.LEADING, false, labels);
    public static final AttributeKey<Font> FONT_FACE = new AttributeKey<Font>("fontFace", Font.class, new Font("VERDANA", 0, 10), false, labels);
    public static final AttributeKey<Double> FONT_SIZE = new AttributeKey<Double>("fontSize", Double.class, 12.0, false, labels);
    public static final AttributeKey<Boolean> FONT_BOLD = new AttributeKey<Boolean>("fontBold", Boolean.class, false, false, labels);
    public static final AttributeKey<Boolean> FONT_ITALIC = new AttributeKey<Boolean>("fontItalic", Boolean.class, false, false, labels);
    public static final AttributeKey<Boolean> FONT_UNDERLINE = new AttributeKey<Boolean>("fontUnderlined", Boolean.class, false, false, labels);
    public static final AttributeKey<Liner> BEZIER_PATH_LAYOUTER = new AttributeKey<Object>("bezierPathLayouter", Liner.class, null, true, labels);
    public static final AttributeKey<LineDecoration> END_DECORATION = new AttributeKey<Object>("endDecoration", LineDecoration.class, null, true, labels);
    public static final AttributeKey<LineDecoration> START_DECORATION = new AttributeKey<Object>("startDecoration", LineDecoration.class, null, true, labels);
    public static final AttributeKey<Insets2D.Double> DECORATOR_INSETS = new AttributeKey<Insets2D.Double>("decoratorInsets", Insets2D.Double.class, new Insets2D.Double(), false, labels);
    public static final AttributeKey<Insets2D.Double> LAYOUT_INSETS = new AttributeKey<Insets2D.Double>("borderInsets", Insets2D.Double.class, new Insets2D.Double(), false, labels);
    public static final AttributeKey<Alignment> COMPOSITE_ALIGNMENT = new AttributeKey<Alignment>("layoutAlignment", Alignment.class, Alignment.BLOCK, false, labels);
    public static final AttributeKey<Alignment> CHILD_ALIGNMENT = new AttributeKey<Object>("layoutAlignment", Alignment.class, null, true, labels);
    public static final AttributeKey<AffineTransform> TRANSFORM = new AttributeKey<Object>("transform", AffineTransform.class, null, true, labels);
    public static final AttributeKey<Orientation> ORIENTATION = new AttributeKey<Orientation>("orientation", Orientation.class, Orientation.NORTH, false, labels);
    public static final Set<AttributeKey> supportedAttributes;
    public static final Map<String, AttributeKey> supportedAttributeMap;

    public static double getStrokeTotalWidth(Figure f) {
        switch (STROKE_TYPE.get(f)) {
            default: {
                return STROKE_WIDTH.get(f);
            }
            case DOUBLE: 
        }
        return STROKE_WIDTH.get(f) * (1.0 + STROKE_INNER_WIDTH_FACTOR.get(f));
    }

    public static double getStrokeTotalMiterLimit(Figure f) {
        if (IS_STROKE_MITER_LIMIT_FACTOR.get(f).booleanValue()) {
            return STROKE_MITER_LIMIT.get(f) * STROKE_WIDTH.get(f);
        }
        return STROKE_MITER_LIMIT.get(f);
    }

    public static Stroke getStroke(Figure f) {
        double strokeWidth = STROKE_WIDTH.get(f);
        float miterLimit = (float)AttributeKeys.getStrokeTotalMiterLimit(f);
        double dashFactor = IS_STROKE_DASH_FACTOR.get(f) != false ? strokeWidth : 1.0;
        double dashPhase = STROKE_DASH_PHASE.get(f);
        double[] ddashes = STROKE_DASHES.get(f);
        float[] dashes = null;
        boolean isAllZeroes = true;
        if (ddashes != null) {
            dashes = new float[ddashes.length];
            double dashSize = 0.0;
            for (int i = 0; i < dashes.length; ++i) {
                dashes[i] = Math.max(0.0f, (float)(ddashes[i] * dashFactor));
                dashSize += (double)dashes[i];
                if (!isAllZeroes || dashes[i] == 0.0f) continue;
                isAllZeroes = false;
            }
            if (dashes.length % 2 == 1) {
                dashSize *= 2.0;
            }
            if (dashPhase < 0.0) {
                dashPhase = dashSize + dashPhase % dashSize;
            }
        }
        if (isAllZeroes) {
            dashes = null;
        }
        switch (STROKE_TYPE.get(f)) {
            default: {
                return new BasicStroke((float)strokeWidth, STROKE_CAP.get(f), STROKE_JOIN.get(f), miterLimit, dashes, Math.max(0.0f, (float)(dashPhase * dashFactor)));
            }
            case DOUBLE: 
        }
        return new DoubleStroke((float)(STROKE_INNER_WIDTH_FACTOR.get(f) * strokeWidth), (float)strokeWidth, STROKE_CAP.get(f), STROKE_JOIN.get(f), miterLimit, dashes, Math.max(0.0f, (float)(dashPhase * dashFactor)));
    }

    public static Stroke getHitStroke(Figure f) {
        double strokeWidth = Math.max(1.0, STROKE_WIDTH.get(f));
        float miterLimit = (float)AttributeKeys.getStrokeTotalMiterLimit(f);
        double dashFactor = IS_STROKE_DASH_FACTOR.get(f) != false ? strokeWidth : 1.0;
        switch (STROKE_TYPE.get(f)) {
            default: {
                return new BasicStroke((float)strokeWidth, STROKE_CAP.get(f), STROKE_JOIN.get(f), miterLimit, null, Math.max(0.0f, (float)(STROKE_DASH_PHASE.get(f) * dashFactor)));
            }
            case DOUBLE: 
        }
        return new DoubleStroke((float)(STROKE_INNER_WIDTH_FACTOR.get(f) * strokeWidth), (float)strokeWidth, STROKE_CAP.get(f), STROKE_JOIN.get(f), miterLimit, null, Math.max(0.0f, (float)((double)STROKE_DASH_PHASE.get(f).floatValue() * dashFactor)));
    }

    public static Font getFont(Figure f) {
        Font prototype = FONT_FACE.get(f);
        if (prototype == null) {
            return null;
        }
        if (AttributeKeys.getFontStyle(f) != 0) {
            return prototype.deriveFont(AttributeKeys.getFontStyle(f), FONT_SIZE.get(f).floatValue());
        }
        return prototype.deriveFont(FONT_SIZE.get(f).floatValue());
    }

    public static int getFontStyle(Figure f) {
        int style = 0;
        if (FONT_BOLD.get(f).booleanValue()) {
            style |= 1;
        }
        if (FONT_ITALIC.get(f).booleanValue()) {
            style |= 2;
        }
        return style;
    }

    public static double getPerpendicularFillGrowth(Figure f) {
        double grow;
        double strokeWidth = AttributeKeys.getStrokeTotalWidth(f);
        StrokePlacement placement = STROKE_PLACEMENT.get(f);
        block0 : switch (FILL_UNDER_STROKE.get(f)) {
            case FULL: {
                switch (placement) {
                    case INSIDE: {
                        grow = 0.0;
                        break block0;
                    }
                    case OUTSIDE: {
                        grow = strokeWidth;
                        break block0;
                    }
                }
                grow = strokeWidth / 2.0;
                break;
            }
            case NONE: {
                switch (placement) {
                    case INSIDE: {
                        grow = -strokeWidth;
                        break block0;
                    }
                    case OUTSIDE: {
                        grow = 0.0;
                        break block0;
                    }
                }
                grow = strokeWidth / -2.0;
                break;
            }
            default: {
                switch (placement) {
                    case INSIDE: {
                        grow = strokeWidth / -2.0;
                        break block0;
                    }
                    case OUTSIDE: {
                        grow = strokeWidth / 2.0;
                        break block0;
                    }
                }
                grow = 0.0;
            }
        }
        return grow;
    }

    public static double getPerpendicularDrawGrowth(Figure f) {
        double grow;
        double strokeWidth = AttributeKeys.getStrokeTotalWidth(f);
        switch (STROKE_PLACEMENT.get(f)) {
            case INSIDE: {
                grow = strokeWidth / -2.0;
                break;
            }
            case OUTSIDE: {
                grow = strokeWidth / 2.0;
                break;
            }
            default: {
                grow = 0.0;
            }
        }
        return grow;
    }

    public static double getPerpendicularHitGrowth(Figure f) {
        double grow;
        if (STROKE_COLOR.get(f) == null) {
            grow = AttributeKeys.getPerpendicularFillGrowth(f);
        } else {
            double strokeWidth = AttributeKeys.getStrokeTotalWidth(f);
            grow = AttributeKeys.getPerpendicularDrawGrowth(f) + strokeWidth / 2.0;
        }
        return grow;
    }

    static {
        HashSet<AttributeKey> as = new HashSet<AttributeKey>();
        as.addAll(Arrays.asList(FILL_COLOR, FILL_UNDER_STROKE, STROKE_COLOR, STROKE_WIDTH, STROKE_INNER_WIDTH_FACTOR, STROKE_JOIN, STROKE_CAP, STROKE_MITER_LIMIT, STROKE_DASHES, STROKE_DASH_PHASE, STROKE_TYPE, STROKE_PLACEMENT, TEXT, TEXT_COLOR, TEXT_SHADOW_COLOR, TEXT_SHADOW_OFFSET, TRANSFORM, FONT_FACE, FONT_SIZE, FONT_BOLD, FONT_ITALIC, FONT_UNDERLINE, BEZIER_PATH_LAYOUTER, END_DECORATION, START_DECORATION, DECORATOR_INSETS, ORIENTATION, WINDING_RULE));
        supportedAttributes = Collections.unmodifiableSet(as);
        HashMap<String, AttributeKey> am = new HashMap<String, AttributeKey>();
        for (AttributeKey a : as) {
            am.put(a.getKey(), a);
        }
        supportedAttributeMap = Collections.unmodifiableMap(am);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        NORTH_WEST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEADING,
        TRAILING,
        CENTER,
        BLOCK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StrokePlacement {
        CENTER,
        INSIDE,
        OUTSIDE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StrokeType {
        BASIC,
        DOUBLE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Underfill {
        NONE,
        CENTER,
        FULL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WindingRule {
        EVEN_ODD,
        NON_ZERO;

    }
}

