/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.io.Serializable;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.Methods;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeKey<T>
implements Serializable {
    private String key;
    private T defaultValue;
    private boolean isNullValueAllowed;
    private ResourceBundleUtil labels;
    private Class<T> clazz;

    public AttributeKey(String key, Class<T> clazz) {
        this(key, clazz, null, true);
    }

    public AttributeKey(String key, Class<T> clazz, T defaultValue) {
        this(key, clazz, defaultValue, true);
    }

    public AttributeKey(String key, Class<T> clazz, T defaultValue, boolean isNullValueAllowed) {
        this.key = key;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.isNullValueAllowed = isNullValueAllowed;
    }

    public AttributeKey(String key, Class<T> clazz, T defaultValue, boolean isNullValueAllowed, ResourceBundleUtil labels) {
        this.key = key;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.isNullValueAllowed = isNullValueAllowed;
        this.labels = labels;
    }

    public String getKey() {
        return this.key;
    }

    public String getPresentationName() {
        return this.labels == null ? this.key : this.labels.getString("attribute." + this.key + ".text");
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getClone(Figure f) {
        T value = this.get(f);
        try {
            return value == null ? null : (T)this.clazz.cast(Methods.invoke(value, "clone"));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    public T get(Figure f) {
        Object value = f.getAttribute(this);
        return value == null && !this.isNullValueAllowed ? this.defaultValue : value;
    }

    public T get(Map<AttributeKey, Object> a) {
        Object value = a.get(this);
        return (T)(value == null && !this.isNullValueAllowed ? this.defaultValue : value);
    }

    public void set(Figure f, T value) {
        f.willChange();
        this.basicSet(f, value);
        f.changed();
    }

    public void basicSet(Figure f, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        f.setAttribute(this, value);
    }

    public UndoableEdit setUndoable(final Figure figure, final T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        final Object restoreData = figure.getAttributesRestoreData();
        figure.willChange();
        figure.setAttribute(this, value);
        figure.changed();
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            public String getPresentationName() {
                return AttributeKey.this.getPresentationName();
            }

            public void undo() {
                super.undo();
                figure.willChange();
                figure.restoreAttributesTo(restoreData);
                figure.changed();
            }

            public void redo() {
                super.redo();
                figure.willChange();
                figure.setAttribute(AttributeKey.this, value);
                figure.changed();
            }
        };
        return edit;
    }

    public void setClone(Figure f, T value) {
        f.willChange();
        this.basicSetClone(f, value);
        f.changed();
    }

    public void basicSetClone(Figure f, T value) {
        try {
            this.basicSet(f, value == null ? null : (T)this.clazz.cast(Methods.invoke(value, "clone")));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    public void set(Map<AttributeKey, Object> a, T value) {
        this.put(a, value);
    }

    public T put(Map<AttributeKey, Object> a, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        return (T)a.put(this, value);
    }

    public void setClone(Map<AttributeKey, Object> a, T value) {
        try {
            this.set(a, value == null ? null : Methods.invoke(value, "clone"));
        }
        catch (NoSuchMethodException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    public boolean isNullValueAllowed() {
        return this.isNullValueAllowed;
    }

    public boolean isAssignable(Object value) {
        if (value == null) {
            return this.isNullValueAllowed();
        }
        return this.clazz.isInstance(value);
    }

    public String toString() {
        return this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof AttributeKey) {
            return ((AttributeKey)that).key.equals(this.key);
        }
        return false;
    }
}

