/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;
import org.jhotdraw.draw.action.DrawingEditorProxy;
import org.jhotdraw.draw.action.IncreaseHandleDetailLevelAction;
import org.jhotdraw.draw.action.MoveAction;
import org.jhotdraw.draw.action.MoveConstrainedAction;

public abstract class AbstractTool
extends AbstractBean
implements Tool {
    private boolean isActive;
    protected boolean isWorking;
    protected DrawingEditor editor;
    protected Point anchor = new Point();
    protected EventListenerList listenerList = new EventListenerList();
    private DrawingEditorProxy editorProxy = new DrawingEditorProxy();
    private InputMap inputMap;
    private ActionMap actionMap;

    public AbstractTool() {
        this.setInputMap(this.createInputMap());
        this.setActionMap(this.createActionMap());
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.listenerList.add(UndoableEditListener.class, l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.listenerList.remove(UndoableEditListener.class, l);
    }

    public void activate(DrawingEditor editor) {
        this.editor = editor;
        this.editorProxy.setTarget(editor);
        this.isActive = true;
        for (DrawingView v : editor.getDrawingViews()) {
            v.repaintHandles();
        }
    }

    public void deactivate(DrawingEditor editor) {
        this.editor = editor;
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected DrawingView getView() {
        return this.editor.getActiveView();
    }

    protected DrawingEditor getEditor() {
        return this.editor;
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected Point2D.Double viewToDrawing(Point p) {
        return this.constrainPoint(this.getView().viewToDrawing(p));
    }

    protected Point2D.Double constrainPoint(Point p) {
        return this.constrainPoint(this.getView().viewToDrawing(p));
    }

    protected Point2D.Double constrainPoint(Point2D.Double p) {
        return this.getView().getConstrainer().constrainPoint(p);
    }

    public void setInputMap(InputMap newValue) {
        this.inputMap = newValue;
    }

    public InputMap getInputMap() {
        return this.inputMap;
    }

    public void setActionMap(ActionMap newValue) {
        this.actionMap = newValue;
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public void editDelete() {
        this.getView().getDrawing().removeAll(this.getView().getSelectedFigures());
    }

    public void editCut() {
    }

    public void editCopy() {
    }

    public void editDuplicate() {
    }

    public void editPaste() {
    }

    public void keyReleased(KeyEvent evt) {
        this.fireToolDone();
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        if (!evt.isConsumed()) {
            if (evt.getSource() instanceof Container) {
                this.editor.setActiveView(this.editor.findView((Container)evt.getSource()));
            }
            if (this.inputMap != null) {
                Object obj = this.inputMap.get(KeyStroke.getKeyStroke(evt.getKeyCode(), evt.getModifiers(), false));
                ActionListener al = null;
                if (obj instanceof ActionListener) {
                    al = (ActionListener)obj;
                } else if (obj != null && this.actionMap != null) {
                    al = this.actionMap.get(obj);
                }
                if (al != null) {
                    evt.consume();
                    al.actionPerformed(new ActionEvent(this, 1001, "tool", evt.getWhen(), evt.getModifiers()));
                    this.fireToolDone();
                }
            }
        }
    }

    protected InputMap createInputMap() {
        InputMap m = new InputMap();
        m.put(KeyStroke.getKeyStroke(127, 0), "edit.delete");
        m.put(KeyStroke.getKeyStroke(8, 0), "edit.delete");
        m.put(KeyStroke.getKeyStroke(65, 0), "edit.selectAll");
        m.put(KeyStroke.getKeyStroke(65, 128), "edit.selectAll");
        m.put(KeyStroke.getKeyStroke(65, 256), "edit.selectAll");
        m.put(KeyStroke.getKeyStroke(32, 0), "view.increaseHandleDetailLevel");
        m.put(KeyStroke.getKeyStroke(37, 0), "edit.moveConstrainedWest");
        m.put(KeyStroke.getKeyStroke(39, 0), "edit.moveConstrainedEast");
        m.put(KeyStroke.getKeyStroke(38, 0), "edit.moveConstrainedNorth");
        m.put(KeyStroke.getKeyStroke(40, 0), "edit.moveConstrainedSouth");
        m.put(KeyStroke.getKeyStroke(37, 512), "edit.moveWest");
        m.put(KeyStroke.getKeyStroke(39, 512), "edit.moveEast");
        m.put(KeyStroke.getKeyStroke(38, 512), "edit.moveNorth");
        m.put(KeyStroke.getKeyStroke(40, 512), "edit.moveSouth");
        m.put(KeyStroke.getKeyStroke(37, 64), "edit.moveWest");
        m.put(KeyStroke.getKeyStroke(39, 64), "edit.moveEast");
        m.put(KeyStroke.getKeyStroke(38, 64), "edit.moveNorth");
        m.put(KeyStroke.getKeyStroke(40, 64), "edit.moveSouth");
        m.put(KeyStroke.getKeyStroke(37, 128), "edit.moveWest");
        m.put(KeyStroke.getKeyStroke(39, 128), "edit.moveEast");
        m.put(KeyStroke.getKeyStroke(38, 128), "edit.moveNorth");
        m.put(KeyStroke.getKeyStroke(40, 128), "edit.moveSouth");
        m.put(KeyStroke.getKeyStroke(67, 128), "edit.copy");
        m.put(KeyStroke.getKeyStroke(67, 256), "edit.copy");
        m.put(KeyStroke.getKeyStroke(86, 128), "edit.paste");
        m.put(KeyStroke.getKeyStroke(86, 256), "edit.paste");
        m.put(KeyStroke.getKeyStroke(88, 128), "edit.cut");
        m.put(KeyStroke.getKeyStroke(88, 256), "edit.cut");
        return m;
    }

    protected ActionMap createActionMap() {
        ActionMap m = new ActionMap();
        m.put("edit.delete", new DeleteAction());
        m.put("edit.selectAll", new SelectAllAction());
        m.put("view.increaseHandleDetailLevel", new IncreaseHandleDetailLevelAction(this.editorProxy));
        m.put("edit.moveEast", new MoveAction.East(this.editorProxy));
        m.put("edit.moveWest", new MoveAction.West(this.editorProxy));
        m.put("edit.moveNorth", new MoveAction.North(this.editorProxy));
        m.put("edit.moveSouth", new MoveAction.South(this.editorProxy));
        m.put("edit.moveConstrainedEast", new MoveConstrainedAction.East(this.editorProxy));
        m.put("edit.moveConstrainedWest", new MoveConstrainedAction.West(this.editorProxy));
        m.put("edit.moveConstrainedNorth", new MoveConstrainedAction.North(this.editorProxy));
        m.put("edit.moveConstrainedSouth", new MoveConstrainedAction.South(this.editorProxy));
        m.put("edit.cut", new CutAction());
        m.put("edit.copy", new CopyAction());
        m.put("edit.paste", new PasteAction());
        return m;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        DrawingView view = this.editor.findView((Container)evt.getSource());
        view.requestFocus();
        this.anchor = new Point(evt.getX(), evt.getY());
        this.isWorking = true;
        this.fireToolStarted(view);
    }

    public void mouseReleased(MouseEvent evt) {
        this.isWorking = false;
    }

    public void addToolListener(ToolListener l) {
        this.listenerList.add(ToolListener.class, l);
    }

    public void removeToolListener(ToolListener l) {
        this.listenerList.remove(ToolListener.class, l);
    }

    protected void fireToolStarted(DrawingView view) {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, view, new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)listeners[i + 1]).toolStarted(event);
        }
    }

    protected void fireToolDone() {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, this.getView(), new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)listeners[i + 1]).toolDone(event);
        }
    }

    protected void fireAreaInvalidated(Rectangle2D.Double r) {
        Point p1 = this.getView().drawingToView(new Point2D.Double(r.x, r.y));
        Point p2 = this.getView().drawingToView(new Point2D.Double(r.x + r.width, r.y + r.height));
        this.fireAreaInvalidated(new Rectangle(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y));
    }

    protected void fireAreaInvalidated(Rectangle invalidatedArea) {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, this.getView(), invalidatedArea);
            }
            ((ToolListener)listeners[i + 1]).areaInvalidated(event);
        }
    }

    public void draw(Graphics2D g) {
    }

    public void updateCursor(DrawingView view, Point p) {
        if (view.isEnabled()) {
            Handle handle = view.findHandle(p);
            if (handle != null) {
                view.setCursor(handle.getCursor());
            } else {
                Figure figure = view.findFigure(p);
                Point2D.Double point = view.viewToDrawing(p);
                Drawing drawing = view.getDrawing();
                while (figure != null && !figure.isSelectable()) {
                    figure = drawing.findFigureBehind(point, figure);
                }
                if (figure != null) {
                    view.setCursor(figure.getCursor(view.viewToDrawing(p)));
                } else {
                    view.setCursor(Cursor.getDefaultCursor());
                }
            }
        } else {
            view.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public String getToolTipText(DrawingView view, MouseEvent evt) {
        return null;
    }

    public boolean supportsHandleInteraction() {
        return false;
    }
}

