/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ChopRectangleConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Options;
import org.jhotdraw.draw.ResizeHandleKit;
import org.jhotdraw.draw.SetBoundsEdit;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Dimension2DDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFigure
extends AbstractBean
implements Figure {
    protected EventListenerList listenerList = new EventListenerList();
    private Drawing drawing;
    private boolean isSelectable = true;
    private boolean isRemovable = true;
    private boolean isVisible = true;
    private boolean isTransformable = true;
    protected int changingDepth = 0;

    @Override
    public void addFigureListener(FigureListener l) {
        this.listenerList.add(FigureListener.class, l);
    }

    @Override
    public void removeFigureListener(FigureListener l) {
        this.listenerList.remove(FigureListener.class, l);
    }

    @Override
    public void addNotify(Drawing d) {
        this.drawing = d;
        this.fireFigureAdded();
    }

    @Override
    public void removeNotify(Drawing d) {
        this.fireFigureRemoved();
        this.drawing = null;
    }

    protected Drawing getDrawing() {
        return this.drawing;
    }

    protected Object getLock() {
        return this.getDrawing() == null ? this : this.getDrawing().getLock();
    }

    public void fireAreaInvalidated() {
        this.fireAreaInvalidated(this.getDrawingArea());
    }

    protected void fireAreaInvalidated(Rectangle2D.Double invalidatedArea) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, invalidatedArea);
                }
                ((FigureListener)listeners[i + 1]).areaInvalidated(event);
            }
        }
    }

    protected void fireAreaInvalidated(FigureEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FigureListener.class) continue;
            ((FigureListener)listeners[i + 1]).areaInvalidated(event);
        }
    }

    protected void fireFigureRequestRemove() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)listeners[i + 1]).figureRequestRemove(event);
            }
        }
    }

    protected void fireFigureAdded() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)listeners[i + 1]).figureAdded(event);
            }
        }
    }

    protected void fireFigureRemoved() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)listeners[i + 1]).figureRemoved(event);
            }
        }
    }

    public void fireFigureChanged() {
        this.fireFigureChanged(this.getBounds());
    }

    protected void fireFigureChanged(Rectangle2D.Double changedArea) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, changedArea);
                }
                ((FigureListener)listeners[i + 1]).figureChanged(event);
            }
        }
    }

    protected void fireFigureChanged(FigureEvent event) {
        if (this.listenerList.getListenerCount() > 0) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                ((FigureListener)listeners[i + 1]).figureChanged(event);
            }
        }
    }

    protected void fireAttributeChanged(AttributeKey attribute, Object oldValue, Object newValue) {
        if (!(this.listenerList.getListenerCount() <= 0 || oldValue != null && newValue != null && oldValue.equals(newValue))) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, attribute, oldValue, newValue);
                }
                ((FigureListener)listeners[i + 1]).attributeChanged(event);
            }
        }
    }

    protected void fireFigureHandlesChanged() {
        Rectangle2D.Double changedArea = this.getDrawingArea();
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureListener.class) continue;
                if (event == null) {
                    event = new FigureEvent(this, changedArea);
                }
                ((FigureListener)listeners[i + 1]).figureHandlesChanged(event);
            }
        }
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        if (this.getDrawing() != null) {
            this.getDrawing().fireUndoableEditHappened(edit);
        }
    }

    @Override
    public AbstractFigure clone() {
        AbstractFigure that = (AbstractFigure)super.clone();
        that.listenerList = new EventListenerList();
        that.drawing = null;
        return that;
    }

    public final AbstractFigure basicClone(HashMap<Figure, Figure> oldToNew) {
        return null;
    }

    @Override
    public void remap(Map<Figure, Figure> oldToNew, boolean disconnectIfNotInMap) {
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, handles);
            }
        }
        return handles;
    }

    @Override
    public Cursor getCursor(Point2D.Double p) {
        if (this.contains(p)) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getDefaultCursor();
    }

    public final void setBounds(Rectangle2D.Double bounds) {
        this.setBounds(new Point2D.Double(bounds.x, bounds.y), new Point2D.Double(bounds.x + bounds.width, bounds.y + bounds.height));
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        Point2D.Double oldAnchor = this.getStartPoint();
        Point2D.Double oldLead = this.getEndPoint();
        if (!oldAnchor.equals(anchor) || !oldLead.equals(lead)) {
            this.willChange();
            this.setBounds(anchor, lead);
            this.changed();
            this.fireUndoableEditHappened(new SetBoundsEdit(this, oldAnchor, oldLead, anchor, lead));
        }
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    protected void invalidate() {
    }

    protected boolean isChanging() {
        return this.changingDepth != 0;
    }

    protected int getChangingDepth() {
        return this.changingDepth;
    }

    @Override
    public void willChange() {
        if (this.changingDepth == 0) {
            this.fireAreaInvalidated();
            this.invalidate();
        }
        ++this.changingDepth;
    }

    protected void validate() {
    }

    @Override
    public void changed() {
        if (this.changingDepth == 1) {
            this.validate();
            this.fireFigureChanged(this.getDrawingArea());
        } else if (this.changingDepth < 0) {
            throw new InternalError("changed was called without a prior call to willChange.");
        }
        --this.changingDepth;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopRectangleConnector(this);
    }

    @Override
    public boolean includes(Figure figure) {
        return figure == this;
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        return this.contains(p) ? this : null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        return new ChopRectangleConnector(this);
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        return Collections.emptyList();
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        return null;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        return false;
    }

    @Override
    public boolean handleDrop(Point2D.Double p, Collection<Figure> droppedFigures, DrawingView view) {
        return false;
    }

    @Override
    public Point2D.Double getEndPoint() {
        Rectangle2D.Double r = this.getBounds();
        return new Point2D.Double(r.x + r.width, r.y + r.height);
    }

    @Override
    public Point2D.Double getStartPoint() {
        Rectangle2D.Double r = this.getBounds();
        return new Point2D.Double(r.x, r.y);
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double r = this.getBounds();
        return new Dimension2DDouble(r.width, r.height);
    }

    @Override
    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setSelectable(boolean newValue) {
        boolean oldValue = this.isSelectable;
        this.isSelectable = newValue;
        this.firePropertyChange("selectable", oldValue, newValue);
    }

    @Override
    public boolean isRemovable() {
        return this.isRemovable;
    }

    public void setRemovable(boolean newValue) {
        boolean oldValue = this.isRemovable;
        this.isRemovable = newValue;
        this.firePropertyChange("removable", oldValue, newValue);
    }

    @Override
    public boolean isTransformable() {
        return this.isTransformable;
    }

    public void setTransformable(boolean newValue) {
        boolean oldValue = this.isTransformable;
        this.isTransformable = newValue;
        this.firePropertyChange("transformable", oldValue, newValue);
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean newValue) {
        if (newValue != this.isVisible) {
            this.willChange();
            this.isVisible = newValue;
            this.changed();
        }
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> list = new LinkedList<Figure>();
        list.add(this);
        return list;
    }

    protected FontRenderContext getFontRenderContext() {
        FontRenderContext frc = null;
        if (frc == null) {
            frc = new FontRenderContext(new AffineTransform(), Options.isTextAntialiased(), Options.isFractionalMetrics());
        }
        return frc;
    }

    @Override
    public void requestRemove() {
        this.fireFigureRequestRemove();
    }

    @Override
    public int getLayer() {
        return 0;
    }

    @Override
    public String getToolTipText(Point2D.Double p) {
        return null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        buf.append('@');
        buf.append(this.hashCode());
        return buf.toString();
    }

    @Override
    public Collection<Connector> getConnectors(ConnectionFigure prototype) {
        LinkedList<Connector> connectors = new LinkedList<Connector>();
        connectors.add(new ChopRectangleConnector(this));
        return connectors;
    }
}

