/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.DecoratedFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class AbstractConnector
implements Connector {
    private Figure owner;
    private boolean isConnectToDecorator;
    private boolean isStatePersistent;

    public AbstractConnector() {
        this.owner = null;
    }

    public AbstractConnector(Figure owner) {
        this.owner = owner;
    }

    public void setConnectToDecorator(boolean newValue) {
        this.isConnectToDecorator = newValue;
    }

    public boolean isConnectToDecorator() {
        return this.isConnectToDecorator;
    }

    protected final Figure getConnectorTarget(Figure f) {
        return this.isConnectToDecorator && ((DecoratedFigure)f).getDecorator() != null ? ((DecoratedFigure)f).getDecorator() : f;
    }

    public boolean contains(Point2D.Double p) {
        return this.getOwner().contains(p);
    }

    public Point2D.Double findStart(ConnectionFigure connection) {
        return this.findPoint(connection);
    }

    public Point2D.Double findEnd(ConnectionFigure connection) {
        return this.findPoint(connection);
    }

    protected Point2D.Double findPoint(ConnectionFigure connection) {
        return Geom.center(this.getBounds());
    }

    public Figure getOwner() {
        return this.owner;
    }

    protected void setOwner(Figure newValue) {
        this.owner = newValue;
    }

    public Object clone() {
        try {
            AbstractConnector that = (AbstractConnector)super.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            InternalError error = new InternalError(e.toString());
            throw error;
        }
    }

    public void updateStartLocation(Point2D.Double p) {
    }

    public void updateEndLocation(Point2D.Double p) {
    }

    public Point2D.Double getAnchor() {
        return Geom.center(this.getBounds());
    }

    public void updateAnchor(Point2D.Double p) {
    }

    public Rectangle2D.Double getBounds() {
        return this.isConnectToDecorator() ? ((DecoratedFigure)this.getOwner()).getDecorator().getBounds() : this.getOwner().getBounds();
    }

    public void read(DOMInput in) throws IOException {
        if (this.isStatePersistent) {
            this.isConnectToDecorator = in.getAttribute("connectToDecorator", false);
        }
        if (in.getElementCount("Owner") != 0) {
            in.openElement("Owner");
        } else {
            in.openElement("owner");
        }
        this.owner = (Figure)in.readObject(0);
        in.closeElement();
    }

    public void write(DOMOutput out) throws IOException {
        if (this.isStatePersistent && this.isConnectToDecorator) {
            out.addAttribute("connectToDecorator", true);
        }
        out.openElement("Owner");
        out.writeObject(this.getOwner());
        out.closeElement();
    }

    public Rectangle2D.Double getDrawingArea() {
        Point2D.Double anchor = this.getAnchor();
        return new Rectangle2D.Double(anchor.x - 4.0, anchor.y - 4.0, 8.0, 8.0);
    }

    public void draw(Graphics2D g) {
        Point2D.Double anchor = this.getAnchor();
        Ellipse2D.Double e = new Ellipse2D.Double(anchor.x - 3.0, anchor.y - 3.0, 6.0, 6.0);
        g.setColor(Color.BLUE);
        g.fill(e);
    }
}

