/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;

public class SaveAction
extends AbstractViewAction {
    public static final String ID = "file.save";
    private boolean saveAs;
    private Component oldFocusOwner;

    public SaveAction(Application app) {
        this(app, false);
    }

    public SaveAction(Application app, boolean saveAs) {
        super(app);
        this.saveAs = saveAs;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    public void actionPerformed(ActionEvent evt) {
        final View view = this.getActiveView();
        if (view.isEnabled()) {
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(view.getComponent()).getFocusOwner();
            view.setEnabled(false);
            if (!this.saveAs && view.getFile() != null && view.canSaveTo(view.getFile())) {
                this.saveToFile(view, view.getFile());
            } else {
                JFileChooser fileChooser = view.getSaveChooser();
                JSheet.showSaveSheet(fileChooser, view.getComponent(), new SheetListener(){

                    public void optionSelected(SheetEvent evt) {
                        if (evt.getOption() == 0) {
                            File file = evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()) : evt.getFileChooser().getSelectedFile();
                            SaveAction.this.saveToFile(view, file);
                        } else {
                            view.setEnabled(true);
                            if (SaveAction.this.oldFocusOwner != null) {
                                SaveAction.this.oldFocusOwner.requestFocus();
                            }
                        }
                    }
                });
            }
        }
    }

    protected void saveToFile(final View view, final File file) {
        view.execute(new Worker(){

            public Object construct() {
                try {
                    view.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            public void finished(Object value) {
                SaveAction.this.fileSaved(view, file, value);
            }
        });
    }

    protected void fileSaved(View view, File file, Object value) {
        if (value == null) {
            view.setFile(file);
            view.markChangesAsSaved();
            int multiOpenId = 1;
            for (View p : view.getApplication().views()) {
                if (p == view || p.getFile() == null || !p.getFile().equals(file)) continue;
                multiOpenId = Math.max(multiOpenId, p.getMultipleOpenId() + 1);
            }
            this.getApplication().addRecentFile(file);
            view.setMultipleOpenId(multiOpenId);
        } else {
            String message = value instanceof Throwable && ((Throwable)value).getMessage() != null ? ((Throwable)value).getMessage() : value.toString();
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            JSheet.showMessageSheet((Component)this.getActiveView().getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("couldntSave", file.getName()) + "</b><br>" + (message == null ? "" : message)), 0);
        }
        view.setEnabled(true);
        SwingUtilities.getWindowAncestor(view.getComponent()).toFront();
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }
}

