/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.ResourceBundleUtil;

public class OpenAction
extends AbstractApplicationAction {
    public static final String ID = "file.open";

    public OpenAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    protected JFileChooser getFileChooser(View view) {
        return view.getOpenChooser();
    }

    public void actionPerformed(ActionEvent evt) {
        Application app = this.getApplication();
        if (app.isEnabled()) {
            boolean removeMe;
            View view;
            app.setEnabled(false);
            View emptyView = app.getActiveView();
            if (emptyView == null || emptyView.getFile() != null || emptyView.hasUnsavedChanges()) {
                emptyView = null;
            }
            if (emptyView == null) {
                view = app.createView();
                app.add(view);
                removeMe = true;
            } else {
                view = emptyView;
                removeMe = false;
            }
            JFileChooser fileChooser = this.getFileChooser(view);
            if (fileChooser.showOpenDialog(app.getComponent()) == 0) {
                app.show(view);
                this.openFile(fileChooser, view);
            } else {
                if (removeMe) {
                    app.remove(view);
                }
                app.setEnabled(true);
            }
        }
    }

    protected void openFile(JFileChooser fileChooser, final View view) {
        Application app = this.getApplication();
        final File file = fileChooser.getSelectedFile();
        app.setEnabled(true);
        view.setEnabled(false);
        int multipleOpenId = 1;
        for (View aView : app.views()) {
            if (aView == view || aView.getFile() == null || !aView.getFile().equals(file)) continue;
            multipleOpenId = Math.max(multipleOpenId, aView.getMultipleOpenId() + 1);
        }
        view.setMultipleOpenId(multipleOpenId);
        view.setEnabled(false);
        view.execute(new Worker(){

            public Object construct() {
                try {
                    if (file.exists()) {
                        view.read(file);
                        return null;
                    }
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                    return new IOException(labels.getFormatted("file.open.fileDoesNotExist.message", file.getName()));
                }
                catch (Throwable e) {
                    return e;
                }
            }

            public void finished(Object value) {
                OpenAction.this.fileOpened(view, file, value);
            }
        });
    }

    protected void fileOpened(View view, File file, Object value) {
        Application app = this.getApplication();
        if (value == null) {
            view.setFile(file);
            view.setEnabled(true);
            Frame w = (Frame)SwingUtilities.getWindowAncestor(view.getComponent());
            if (w != null) {
                w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                w.toFront();
            }
            view.getComponent().requestFocus();
            app.addRecentFile(file);
            app.setEnabled(true);
        } else {
            String message;
            view.setEnabled(true);
            app.setEnabled(true);
            if (value instanceof Throwable && ((Throwable)value).getMessage() != null) {
                message = ((Throwable)value).getMessage();
                ((Throwable)value).printStackTrace();
            } else if (value instanceof Throwable) {
                message = value.toString();
                ((Throwable)value).printStackTrace();
            } else {
                message = value.toString();
            }
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
            JSheet.showMessageSheet((Component)view.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>" + labels.getFormatted("file.open.couldntOpen.message", file.getName()) + "</b><br>" + (message == null ? "" : message)), 0);
        }
    }
}

