/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.View;
import org.jhotdraw.util.ResourceBundleUtil;

public class FocusAction
extends AbstractAction {
    public static final String ID = "window.focus";
    private View view;

    public FocusAction(View view) {
        this.view = view;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
        this.setEnabled(view != null);
        view.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
                String name = evt.getPropertyName();
                if (name.equals("file")) {
                    FocusAction.this.putValue("Name", evt.getNewValue() == null ? labels.getString("unnamedFile") : ((File)evt.getNewValue()).getName());
                }
            }
        });
    }

    public Object getValue(String key) {
        if (key == "Name" && this.view != null) {
            return this.getTitle();
        }
        return super.getValue(key);
    }

    private String getTitle() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        String title = labels.getString("unnamedFile");
        if (this.view != null) {
            File file = this.view.getFile();
            title = file == null ? labels.getString("unnamedFile") : file.getName();
            if (this.view.hasUnsavedChanges()) {
                title = title + "*";
            }
            title = labels.getFormatted("internalFrame.title", title, this.view.getApplication().getName(), this.view.getMultipleOpenId());
        }
        return title;
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor(this.view.getComponent());
    }

    private Component getRootPaneContainer() {
        return SwingUtilities.getRootPane(this.view.getComponent()).getParent();
    }

    public void actionPerformed(ActionEvent evt) {
        Component rpContainer = this.getRootPaneContainer();
        if (rpContainer instanceof Frame) {
            Frame frame = (Frame)rpContainer;
            frame.setExtendedState(frame.getExtendedState() & 0xFFFFFFFE);
            frame.toFront();
        } else if (rpContainer instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)rpContainer;
            frame.toFront();
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        this.view.getComponent().requestFocusInWindow();
    }
}

