/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AboutAction;
import org.jhotdraw.app.action.Actions;
import org.jhotdraw.app.action.ClearAction;
import org.jhotdraw.app.action.ClearRecentFilesAction;
import org.jhotdraw.app.action.CloseAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DeleteAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.ExitAction;
import org.jhotdraw.app.action.LoadAction;
import org.jhotdraw.app.action.LoadRecentAction;
import org.jhotdraw.app.action.NewAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.PrintAction;
import org.jhotdraw.app.action.RedoAction;
import org.jhotdraw.app.action.SaveAction;
import org.jhotdraw.app.action.SaveAsAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.app.action.ToggleVisibleAction;
import org.jhotdraw.app.action.UndoAction;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.util.prefs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSDIApplication
extends AbstractApplication {
    private Preferences prefs;

    @Override
    public void launch(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        super.launch(args);
    }

    @Override
    public void init() {
        this.initLookAndFeel();
        super.init();
        this.prefs = Preferences.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLabels();
        this.initApplicationActions();
    }

    @Override
    public void remove(View p) {
        super.remove(p);
        if (this.views().size() == 0) {
            this.stop();
        }
    }

    @Override
    public void configure(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        System.setProperty("swing.aatext", "true");
    }

    protected void initLookAndFeel() {
        try {
            String lafName;
            if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
                lafName = UIManager.getCrossPlatformLookAndFeelClassName();
            } else {
                lafName = UIManager.getSystemLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "");
        }
    }

    protected void initApplicationActions() {
        ResourceBundleUtil appLabels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        ApplicationModel m = this.getModel();
        m.putAction("application.about", new AboutAction(this));
        m.putAction("application.exit", new ExitAction(this));
        m.putAction("file.clear", new ClearAction(this));
        m.putAction("file.new", new NewAction(this));
        appLabels.configureAction(m.getAction("file.new"), "window.new");
        m.putAction("file.load", new LoadAction(this));
        m.putAction("file.clearRecentFiles", new ClearRecentFilesAction(this));
        m.putAction("file.save", new SaveAction(this));
        m.putAction("file.saveAs", new SaveAsAction(this));
        m.putAction("file.close", new CloseAction(this));
        m.putAction("file.print", new PrintAction(this));
        m.putAction("edit.undo", new UndoAction(this));
        m.putAction("edit.redo", new RedoAction(this));
        m.putAction("edit.cut", new CutAction());
        m.putAction("edit.copy", new CopyAction());
        m.putAction("edit.paste", new PasteAction());
        m.putAction("edit.delete", new DeleteAction());
        m.putAction("edit.duplicate", new DuplicateAction());
        m.putAction("edit.selectAll", new SelectAllAction());
    }

    @Override
    protected void initViewActions(View p) {
        ApplicationModel m = this.getModel();
        p.putAction("file.load", m.getAction("file.load"));
    }

    @Override
    public void show(final View p) {
        if (!p.isShowing()) {
            boolean moved;
            p.setShowing(true);
            final JFrame f = new JFrame();
            f.setDefaultCloseOperation(0);
            this.updateViewTitle(p, f);
            JPanel panel = (JPanel)this.wrapViewComponent(p);
            f.add(panel);
            f.setMinimumSize(new Dimension(200, 200));
            f.setPreferredSize(new Dimension(600, 400));
            f.setJMenuBar(this.createMenuBar(p, (List)panel.getClientProperty("toolBarActions")));
            PreferencesUtil.installFramePrefsHandler(this.prefs, "view", f);
            Point loc = f.getLocation();
            block0: do {
                moved = false;
                for (View aView : this.views()) {
                    if (aView == p || SwingUtilities.getWindowAncestor(aView.getComponent()) == null || !SwingUtilities.getWindowAncestor(aView.getComponent()).getLocation().equals(loc)) continue;
                    loc.x += 22;
                    loc.y += 22;
                    moved = true;
                    continue block0;
                }
            } while (moved);
            f.setLocation(loc);
            f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    DefaultSDIApplication.this.getModel().getAction("file.close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
                }

                public void windowClosed(WindowEvent evt) {
                    if (p == DefaultSDIApplication.this.getActiveView()) {
                        DefaultSDIApplication.this.setActiveView(null);
                    }
                    p.stop();
                }

                public void windowActivated(WindowEvent e) {
                    DefaultSDIApplication.this.setActiveView(p);
                }
            });
            p.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("hasUnsavedChanges") || name.equals("file") || name.equals("multipleOpenId")) {
                        DefaultSDIApplication.this.updateViewTitle(p, f);
                    }
                }
            });
            f.setVisible(true);
            p.start();
        }
    }

    protected Component wrapViewComponent(View p) {
        JComponent c = p.getComponent();
        if (this.getModel() != null) {
            LinkedList<ToggleVisibleAction> toolBarActions = new LinkedList<ToggleVisibleAction>();
            int id = 0;
            for (JToolBar tb : new ReversedList<JToolBar>(this.getModel().createToolBars(this, p))) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)tb, "North");
                panel.add((Component)c, "Center");
                c = panel;
                PreferencesUtil.installToolBarPrefsHandler(this.prefs, "toolbar." + ++id, tb);
                toolBarActions.addFirst(new ToggleVisibleAction(tb, tb.getName()));
            }
            c.putClientProperty("toolBarActions", toolBarActions);
        }
        return c;
    }

    @Override
    public void hide(View p) {
        if (p.isShowing()) {
            p.setShowing(false);
            JFrame f = (JFrame)SwingUtilities.getWindowAncestor(p.getComponent());
            f.setVisible(false);
            f.remove(p.getComponent());
            f.dispose();
        }
    }

    @Override
    public void dispose(View p) {
        super.dispose(p);
        if (this.views().size() == 0) {
            this.stop();
        }
    }

    protected JMenuBar createMenuBar(View p, List<Action> toolBarActions) {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu(p));
        JMenu lastMenu = null;
        for (JMenu mm : this.getModel().createMenus(this, p)) {
            mb.add(mm);
            lastMenu = mm;
        }
        JMenu viewMenu = this.createViewMenu(p, toolBarActions);
        if (viewMenu != null) {
            if (lastMenu != null && lastMenu.getText().equals(viewMenu.getText())) {
                for (Component c : lastMenu.getMenuComponents()) {
                    viewMenu.add(c);
                }
                mb.remove(lastMenu);
            }
            mb.add(viewMenu);
        }
        JMenu helpMenu = this.createHelpMenu(p);
        for (Component mc : mb.getComponents()) {
            JMenu m = (JMenu)mc;
            if (!m.getText().equals(helpMenu.getText())) continue;
            for (Component c : helpMenu.getMenuComponents()) {
                m.add(c);
            }
            helpMenu = null;
            break;
        }
        if (helpMenu != null) {
            mb.add(helpMenu);
        }
        return mb;
    }

    protected JMenu createFileMenu(final View p) {
        ApplicationModel model = this.getModel();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu();
        labels.configureMenu(m, "file");
        m.add(model.getAction("file.clear"));
        m.add(model.getAction("file.new"));
        m.add(model.getAction("file.load"));
        if (model.getAction("file.loadDirectory") != null) {
            m.add(model.getAction("file.loadDirectory"));
        }
        final JMenu openRecentMenu = new JMenu();
        labels.configureMenu(openRecentMenu, "file.openRecent");
        openRecentMenu.add(model.getAction("file.clearRecentFiles"));
        this.updateOpenRecentMenu(openRecentMenu);
        m.add(openRecentMenu);
        m.addSeparator();
        m.add(model.getAction("file.save"));
        m.add(model.getAction("file.saveAs"));
        if (model.getAction("file.export") != null) {
            JMenuItem jMenuItem = m.add(model.getAction("file.export"));
        }
        if (model.getAction("file.print") != null) {
            m.addSeparator();
            m.add(model.getAction("file.print"));
        }
        m.addSeparator();
        m.add(model.getAction("application.exit"));
        mb.add(m);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name == "viewCount") {
                    if (p != null && !DefaultSDIApplication.this.views().contains(p)) {
                        DefaultSDIApplication.this.removePropertyChangeListener(this);
                    }
                } else if (name == "recentFiles") {
                    DefaultSDIApplication.this.updateOpenRecentMenu(openRecentMenu);
                }
            }
        });
        return m;
    }

    protected void updateViewTitle(View p, JFrame f) {
        File file = p.getFile();
        String title = file == null ? this.labels.getString("unnamedFile") : file.getName();
        if (p.hasUnsavedChanges()) {
            title = title + "*";
        }
        p.setTitle(this.labels.getFormatted("frame.title", title, this.getName(), p.getMultipleOpenId()));
        f.setTitle(p.getTitle());
    }

    protected void updateOpenRecentMenu(JMenu openRecentMenu) {
        if (openRecentMenu.getItemCount() > 0) {
            JMenuItem clearRecentFilesItem = openRecentMenu.getItem(openRecentMenu.getItemCount() - 1);
            openRecentMenu.removeAll();
            for (File f : this.recentFiles()) {
                openRecentMenu.add(new LoadRecentAction(this, f));
            }
            if (this.recentFiles().size() > 0) {
                openRecentMenu.addSeparator();
            }
            openRecentMenu.add(clearRecentFilesItem);
        }
    }

    @Override
    public boolean isSharingToolsAmongViews() {
        return false;
    }

    @Override
    public Component getComponent() {
        View p = this.getActiveView();
        return p == null ? null : p.getComponent();
    }

    protected JMenu createViewMenu(View p, List<Action> viewActions) {
        ApplicationModel model = this.getModel();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        JMenu m = new JMenu();
        if (viewActions != null && viewActions.size() > 0) {
            JMenu m2 = viewActions.size() == 1 ? m : new JMenu(labels.getString("toolBars"));
            labels.configureMenu(m, "view");
            for (Action a : viewActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                Actions.configureJCheckBoxMenuItem(cbmi, a);
                m2.add(cbmi);
            }
            if (m2 != m) {
                m.add(m2);
            }
        }
        return m.getComponentCount() > 0 ? m : null;
    }

    protected JMenu createHelpMenu(View p) {
        ApplicationModel model = this.getModel();
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
        JMenu m = new JMenu();
        labels.configureMenu(m, "help");
        m.add(model.getAction("application.about"));
        return m;
    }
}

