/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.awt.Container;
import java.awt.Window;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.View;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplication
extends AbstractBean
implements Application {
    private LinkedList<View> views = new LinkedList();
    private Collection<View> unmodifiableDocuments;
    private boolean isEnabled = true;
    protected ResourceBundleUtil labels;
    private ApplicationModel model;
    private LinkedList<File> recentFiles = new LinkedList();
    private static final int maxRecentFilesCount = 10;
    private Preferences prefs;
    private View activeView;
    public static final String VIEW_COUNT_PROPERTY = "viewCount";

    @Override
    public void init() {
        this.prefs = Preferences.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        int count = this.prefs.getInt("recentFileCount", 0);
        for (int i = 0; i < count; ++i) {
            String path = this.prefs.get("recentFile." + i, null);
            if (path == null) continue;
            this.recentFiles.add(new File(path));
        }
        if (this.model != null) {
            this.model.initApplication(this);
        }
    }

    @Override
    public void start() {
        final View p = this.createView();
        this.add(p);
        p.setEnabled(false);
        this.show(p);
        p.execute(new Worker(){

            public Object construct() {
                p.clear();
                return null;
            }

            public void finished(Object result) {
                p.setEnabled(true);
            }
        });
    }

    @Override
    public final View createView() {
        View p = this.basicCreateView();
        p.init();
        if (this.getModel() != null) {
            this.getModel().initView(this, p);
        }
        this.initViewActions(p);
        return p;
    }

    @Override
    public void setModel(ApplicationModel newValue) {
        ApplicationModel oldValue = this.model;
        this.model = newValue;
        this.firePropertyChange("model", oldValue, newValue);
    }

    @Override
    public ApplicationModel getModel() {
        return this.model;
    }

    protected View basicCreateView() {
        return this.model.createView();
    }

    public void setActiveView(View newValue) {
        View oldValue = this.activeView;
        if (this.activeView != null) {
            this.activeView.deactivate();
        }
        this.activeView = newValue;
        if (this.activeView != null) {
            this.activeView.activate();
        }
        this.firePropertyChange("activeView", oldValue, newValue);
    }

    @Override
    public View getActiveView() {
        if (this.activeView == null && this.views.size() > 0) {
            return this.views.getLast();
        }
        return this.activeView;
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public String getVersion() {
        return this.model.getVersion();
    }

    @Override
    public String getCopyright() {
        return this.model.getCopyright();
    }

    protected abstract void initViewActions(View var1);

    @Override
    public void stop() {
        for (View p : new LinkedList<View>(this.views())) {
            this.dispose(p);
        }
        System.exit(0);
    }

    @Override
    public void remove(View p) {
        this.hide(p);
        int oldCount = this.views.size();
        this.views.remove(p);
        p.setApplication(null);
        this.firePropertyChange(VIEW_COUNT_PROPERTY, oldCount, this.views.size());
    }

    @Override
    public void add(View p) {
        if (p.getApplication() != this) {
            int oldCount = this.views.size();
            this.views.add(p);
            p.setApplication(this);
            this.firePropertyChange(VIEW_COUNT_PROPERTY, oldCount, this.views.size());
        }
    }

    @Override
    public void dispose(View p) {
        this.remove(p);
        p.dispose();
    }

    @Override
    public Collection<View> views() {
        if (this.unmodifiableDocuments == null) {
            this.unmodifiableDocuments = Collections.unmodifiableCollection(this.views);
        }
        return this.unmodifiableDocuments;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        boolean oldValue = this.isEnabled;
        this.isEnabled = newValue;
        this.firePropertyChange("enabled", oldValue, newValue);
    }

    public Container createContainer() {
        return new JFrame();
    }

    @Override
    public void launch(String[] args) {
        this.configure(args);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AbstractApplication.this.init();
                AbstractApplication.this.start();
            }
        });
    }

    protected void initLabels() {
        this.labels = ResourceBundleUtil.getBundle("org.jhotdraw.app.Labels");
    }

    @Override
    public void configure(String[] args) {
    }

    @Override
    public List<File> recentFiles() {
        return Collections.unmodifiableList(this.recentFiles);
    }

    @Override
    public void clearRecentFiles() {
        List oldValue = (List)this.recentFiles.clone();
        this.recentFiles.clear();
        this.prefs.putInt("recentFileCount", this.recentFiles.size());
        this.firePropertyChange("recentFiles", Collections.unmodifiableList(oldValue), Collections.unmodifiableList(this.recentFiles));
    }

    @Override
    public void addRecentFile(File file) {
        List oldValue = (List)this.recentFiles.clone();
        if (this.recentFiles.contains(file)) {
            this.recentFiles.remove(file);
        }
        this.recentFiles.addFirst(file);
        if (this.recentFiles.size() > 10) {
            this.recentFiles.removeLast();
        }
        this.prefs.putInt("recentFileCount", this.recentFiles.size());
        int i = 0;
        for (File f : this.recentFiles) {
            this.prefs.put("recentFile." + i, f.getPath());
            ++i;
        }
        this.firePropertyChange("recentFiles", oldValue, (Object)0);
        this.firePropertyChange("recentFiles", Collections.unmodifiableList(oldValue), Collections.unmodifiableList(this.recentFiles));
    }

    @Override
    public void removePalette(Window palette) {
    }

    @Override
    public void addPalette(Window palette) {
    }

    @Override
    public void removeWindow(Window window) {
    }

    @Override
    public void addWindow(Window window, View p) {
    }
}

