/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import net.n3.nanoxml.IXMLReader;

class CDATAReader
extends Reader {
    private IXMLReader reader;
    private char savedChar;
    private boolean atEndOfData;

    CDATAReader(IXMLReader reader) {
        this.reader = reader;
        this.savedChar = '\u0000';
        this.atEndOfData = false;
    }

    protected void finalize() throws Throwable {
        this.reader = null;
        super.finalize();
    }

    public int read(char[] buffer, int offset, int size) throws IOException {
        int charsRead = 0;
        if (this.atEndOfData) {
            return -1;
        }
        if (offset + size > buffer.length) {
            size = buffer.length - offset;
        }
        while (charsRead < size) {
            char ch = this.savedChar;
            if (ch == '\u0000') {
                ch = this.reader.read();
            } else {
                this.savedChar = '\u0000';
            }
            if (ch == ']') {
                char ch2 = this.reader.read();
                if (ch2 == ']') {
                    char ch3 = this.reader.read();
                    if (ch3 == '>') {
                        this.atEndOfData = true;
                        break;
                    }
                    this.savedChar = ch2;
                    this.reader.unread(ch3);
                } else {
                    this.reader.unread(ch2);
                }
            }
            buffer[charsRead] = ch;
            ++charsRead;
        }
        if (charsRead == 0) {
            charsRead = -1;
        }
        return charsRead;
    }

    public void close() throws IOException {
        while (!this.atEndOfData) {
            char ch = this.savedChar;
            if (ch == '\u0000') {
                ch = this.reader.read();
            } else {
                this.savedChar = '\u0000';
            }
            if (ch != ']') continue;
            char ch2 = this.reader.read();
            if (ch2 == ']') {
                char ch3 = this.reader.read();
                if (ch3 == '>') break;
                this.savedChar = ch2;
                this.reader.unread(ch3);
                continue;
            }
            this.reader.unread(ch2);
        }
        this.atEndOfData = true;
    }
}

